/*
 * lxlist-t.b.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <e4.h>
#include <exerrors.h>
#include <l_list.h>
#include <lxcall.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#if __CLIP_EXTRACT__
# define clip(none) \
    ((struct clip_type *) (none))
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
typedef struct clip_type {
    unsigned type;
    void *output;
} clip_type;
#endif				/* __CLIP_EXTRACT__ */

extern const char *const x1f4_c1_empty_string;

#if __CLIP_EXTRACT__
static int clip_miss(void *, void *);
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
static int
clip_miss(void *clip, void *data)
{
    int status;
    unsigned type;

    type = byte(data)[0] << 030 | byte(data)[1] << 020 | byte(data)[2] << 010
	| byte(data)[3];
    if (type != X1f4_E4_TEXT) {
	clip(clip)->type = type;

	something missing here

	status = 1;
    } else {
	status = 0;

	l_TEXT(I_TEXT(byte(data) + 8), clip(clip)->output);
    }

    return status;
}
#endif				/* __CLIP_EXTRACT__ */


int
_libx1f4i0_lxlist_b_class_t(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    lxlist_data = lxtext_data->text;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	unsigned size;

	size = dxlist_data->size;
	if (!size) {
	    status = _libx1f4i0_lxlist_stat_null(lxtext_data->text);
	} else {
#if __CLIP_EXTRACT__
	    struct clip_type clip;
#else
	    void *data, *list;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
	    clip.output = output;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
#else
	    list = dxlist_data->list;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
	    status = _libx1f4i0______l4list
		(dxlist_data->list, e, &clip, clip_miss);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_call
		    (lxlist_data, 0, clip.type,
		     lxtext_data->lxtype.code, status);
	    } else {
		dxlist_data->size = size - 1;
	    }
#else
	    status = _libx1f4i0_lead_l4list(list, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != X1f4_E4_TEXT) {
		    status = _libx1f4i0_lxlist_stat_type
			(lxlist_data, 0, type, X1f4_E4_TEXT);
		} else {
		    status = _libx1f4i0_lxcall_pick_text
			(&lxlist_data->link_v, &lxlist_data->link_m,
			 &lxlist_data->link_e, byte(data) + 8);
		    if (status) {
		    } else {
			X1f4_E4_C_TEXT fast;

			fast = I_TEXT(byte(data) + 8);

			status = _libx1f4i0_mind_l4list(list);
			if (status) {
			    byte(data)[4] = ~0 >> 030;
			    byte(data)[5] = ~0 >> 020;
			    byte(data)[6] = ~0 >> 010;
			    byte(data)[7] = ~0 >> 000;

			    status = _libx1f4i0_lxlist_stat_list
				(lxtext_data->text, status);
			} else {
			    dxlist_data->size = size - 1;

			    l_TEXT(fast, output);
			}
		    }
		}
	    }
#endif				/* __CLIP_EXTRACT__ */
	}
    }

    return status;
}
