/*
 * lxlist-p.s.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_s_pending(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	X1f4_E4_C_MODE mode;
	unsigned size;

	mode = I_MODE(input[1]);

	size = dxlist_data->size;
	if (mode < -(X1f4_E4_C_MODE) (int) size
	    || !(mode < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(lxtext_data->text, size, mode);
	} else {
	    void *data;

	    if (mode < 0) {
		mode += size;
	    }

	    status = _libx1f4i0_peek_l4list(dxlist_data->list, mode, &data);
	    if (status) {
		status =
		    _libx1f4i0_lxlist_stat_list(lxtext_data->text, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];

		l_MODE(type == lxtext_data->lxtype.code, output);
	    }
	}
    }

    return status;
}
