/*
 * lxlist-p.l.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <l_list.h>
#include <lxcast.h>
#include <lxlist-close.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <nt.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_l_pending(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE mode;
	int (*copy) (void *, void *, void **, const void *,
		     const struct x1f4_nodelink_type *),
	    (*node) (void *, void **, void *,
		     const struct x1f4_nodelink_type *), type;
	struct dxlist_type *dxlist_data;
	struct lxlist_type *lxlist_data;
	struct lxtext_type *lxtext_data, *lxtext_link;
	struct x1f4_dxcast_type *dxcast_data;
	unsigned miss;
	void *data, *side;

	mode = I_MODE(input[1]);

	lxlist_data = context;

	dxlist_data = I_LIST(input[0]);

	if (0) {
	} else {
	    unsigned size;

	    size = dxlist_data->size + 1;
	    if (mode < -(X1f4_E4_C_MODE) (int) size
		|| !(mode < (X1f4_E4_C_MODE) (int) size)) {
		status = _libx1f4i0_lxlist_stat_deck(lxlist_data, size, mode);
		if (1) {
		    break;
		}
	    } else {
		if (mode < 0) {
		    mode += size;
		}
	    }
	}

	dxcast_data = I_USER(input[2]);

	type = dxcast_data->type;

	lxtext_link = lxlist_data->link_f.text;

	lxtext_data = lxtext_link;

	close_frame(miss, lxtext_data);

	if (miss) {
	    if (lxtext_data->lxtype.flags & X1f4_LX_LINK_ACCESS) {
		node = lxtext_data->lxtype.node;
		copy = NULL;
	    } else {
		node = NULL;
		copy = lxtext_data->lxtype.copy;
		if (copy) {
		    status = copy
			(lxtext_data->lxtype.context, NULL, &side,
			 I_USER(&dxcast_data->data), lock_excase(dxlist_data));
		    if (status) {
			break;
		    }
		}
	    }
	} else {
	    copy = NULL;
	    node = NULL;
	}

	if (0) {
	} else {
	    status = _libx1f4i0_push_l4list(dxlist_data->list, mode, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
		if (copy) {
		    lxtext_data->lxtype.free
			(lxtext_data->lxtype.context, side,
			 NULL, lock_excase(dxlist_data));
		}
	    } else {
		unsigned link;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = miss ? lxtext_data - lxtext_link : ~0;

		if (node) {
		    status = node
			(lxtext_data->lxtype.context,
			 (void **) (byte(data) + 8),
			 I_USER(&dxcast_data->data), lock_excase(dxlist_data));
		    if (status) {
			link = ~0;
		    }
		} else {
		    if (copy) {
			l_USER(side, byte(data) + 8);
		    } else {
			copy_miss(byte(data) + 8, type, &dxcast_data->data);
		    }
		}

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		dxlist_data->size++;
	    }
	}
    } while (0);

    return status;
}
