/*
 * lxlist-p.e.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-parts.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

int
_libx1f4i0_lxlist_e_pending(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE head, tail;
    int status;
    struct dxlist_type *dxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    size = dxlist_data->size;

    head = I_MODE(input[1]);
    if (head < -(X1f4_E4_C_MODE) (int) size
	|| !(head < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck
	    (context, size, head);
    } else {
	tail = I_MODE(input[2]);
	if (tail < -(X1f4_E4_C_MODE) (int) size
	    || !(tail < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(context, size, tail);
	} else {
	    struct pxedit_type pxedit;
	    void *list;

	    if (head < 0) {
		head += size;
	    }

	    if (tail < 0) {
		tail += size;
	    }

	    list = dxlist_data->list;

	    pxedit.excase_data = lock_excase(dxlist_data);
	    pxedit.lxtext_data =
		((struct lxlist_type *) context)->link_f.text;

	    if (tail < head) {
		status = _libx1f4i0_over_l4list
		    (list, head, size - 1, &pxedit,
		     _libx1f4i0_lxlist_miss_link);
		if (status) {
		} else {
		    status = _libx1f4i0_dash_l4list(list, head, size - 1);
		    if (status) {
		    } else {
			status = _libx1f4i0_over_l4list
			    (list, 0, tail, &pxedit,
			     _libx1f4i0_lxlist_miss_link);
			if (status) {
			} else {
			    status = _libx1f4i0_dash_l4list(list, 0, tail);
			    if (status) {
			    } else {
				dxlist_data->size = head - tail - 1;
			    }
			}
		    }
		}
	    } else {
		status = _libx1f4i0_over_l4list
		    (list, head, tail, &pxedit, _libx1f4i0_lxlist_miss_link);
		if (status) {
		} else {
		    status = _libx1f4i0_dash_l4list(list, head, tail);
		    if (status) {
		    } else {
			dxlist_data->size = size - 1 - tail + head;
		    }
		}
	    }
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(context, status);
	    }
	}
    }

    return status;
}
