/*
 * lxlist-l.t.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <e4.h>
#include <fd.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define lxlist(list) \
    ((struct lxlist_type *) (list))

typedef X1f4_E4_C_USER x1f4_e4_c_user;

int
_libx1f4i0_lxlist_t_logique(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE delete;
    int status;
    struct dxlist_type *dxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    delete = I_MODE(input[1]);

    size = dxlist_data->size;
    if (delete < -(X1f4_E4_C_MODE) (int) size
	|| !(delete < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck(context, size, delete);
    } else {
	X1f4_E4_C_MODE insert;
	struct dxlist_type *dxlist_text;
	unsigned mice;

	dxlist_text = I_LIST(input[2]);

	insert = I_MODE(input[3]);

	mice = dxlist_text->size;
	if (insert < -(X1f4_E4_C_MODE) (int) mice
	    || !(insert < (X1f4_E4_C_MODE) (int) mice)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(context, mice, insert);
	} else {
	    void *data;

	    if (insert < 0) {
		insert += mice;
	    }

	    if (delete < 0) {
		delete += size;
	    }

	    status = _libx1f4i0_peek_l4list
		(dxlist_data->list, delete, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(context, status);
	    } else {
		void *text;

		status = _libx1f4i0_peek_l4list
		    (dxlist_text->list, insert, &text);
		if (status) {
		    status =
			_libx1f4i0_lxlist_stat_list(context, status);
		} else {
		    do {
			unsigned link, sand;
			x1f4_e4_c_user Data, Text;

			link = byte(data)[4] << 030 | byte(data)[5] << 020
			    | byte(data)[6] << 010 | byte(data)[7];

			Data = I_USER(byte(data) + 8);

			sand = byte(text)[4] << 030 | byte(text)[5] << 020
			    | byte(text)[6] << 010 | byte(text)[7];

			Text = I_USER(byte(text) + 8);

			{
			    unsigned char byte_slip__i_;

			    byte_slip__i_ = byte(data)[0];
			    byte(data)[0] = byte(text)[0];
			    byte(text)[0] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[1];
			    byte(data)[1] = byte(text)[1];
			    byte(text)[1] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[2];
			    byte(data)[2] = byte(text)[2];
			    byte(text)[2] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[3];
			    byte(data)[3] = byte(text)[3];
			    byte(text)[3] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[4];
			    byte(data)[4] = byte(text)[4];
			    byte(text)[4] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[5];
			    byte(data)[5] = byte(text)[5];
			    byte(text)[5] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[6];
			    byte(data)[6] = byte(text)[6];
			    byte(text)[6] = byte_slip__i_;
			    byte_slip__i_ = byte(data)[7];
			    byte(data)[7] = byte(text)[7];
			    byte(text)[7] = byte_slip__i_;
			}
			{
			    struct fxdata_type fxdata;

			    fxdata = *(struct fxdata_type *) (byte(data) + 8);
			    *(struct fxdata_type *) (byte(data) + 8) =
				*(struct fxdata_type *) (byte(text) + 8);
			    *(struct fxdata_type *) (byte(text) + 8) = fxdata;
			}

			if (0) {
			} else {
			    int (*move) (void *, void *,
					 const struct excase_type *,
					 const struct excase_type *);
			    struct lxlist_type *lxlist_data;
			    struct lxtext_type *lxtext_data;

			    lxlist_data = context;

			    if (~link) {
				lxtext_data = (struct lxtext_type *)
				    lxlist_data->link_f.text + link;

				move = lxtext_data->lxtype.move;
				if (move) {
				    status = move
					(lxtext_data->lxtype.context, Data,
					 lock_excase(dxlist_data),
					 lock_excase(dxlist_text));
				    if (status) {
					break;
				    }
				}
			    }

			    if (~sand) {
				lxtext_data = (struct lxtext_type *)
				    lxlist_data->link_f.text + sand;

				move = lxtext_data->lxtype.move;
				if (move) {
				    status = move
					(lxtext_data->lxtype.context, Text,
					 lock_excase(dxlist_text),
					 lock_excase(dxlist_data));
				    if (status) {
					break;
				    }
				}
			    }
			}
		    } while (0);
		}
	    }
	}
    }

    return status;
}
