/*
 * lxlist-l.s.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <fd.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_s_logique(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	X1f4_E4_C_MODE delete;
	unsigned size;

	delete = I_MODE(input[1]);

	size = dxlist_data->size;
	if (delete < -(X1f4_E4_C_MODE) (int) size
	    || !(delete < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(context, size, delete);
	} else {
	    X1f4_E4_C_MODE insert;

	    insert = I_MODE(input[2]);

	    if (insert < -(X1f4_E4_C_MODE) (int) size
		|| !(insert < (X1f4_E4_C_MODE) (int) size)) {
		status = _libx1f4i0_lxlist_stat_deck
		    (context, size, insert);
	    } else {
		void *data;

		if (insert < 0) {
		    insert += size;
		}

		if (delete < 0) {
		    delete += size;
		}

		status = _libx1f4i0_peek_l4list
		    (dxlist_data->list, delete, &data);
		if (status) {
		    status =
			_libx1f4i0_lxlist_stat_list(context, status);
		} else {
		    void *text;

		    status = _libx1f4i0_peek_l4list
			(dxlist_data->list, insert, &text);
		    if (status) {
			status = _libx1f4i0_lxlist_stat_list
			    (context, status);
		    } else {
			struct fxdata_type fxdata;
			unsigned char byte_slip__i_;

			byte_slip__i_ = byte(data)[0];
			byte(data)[0] = byte(text)[0];
			byte(text)[0] = byte_slip__i_;
			byte_slip__i_ = byte(data)[1];
			byte(data)[1] = byte(text)[1];
			byte(text)[1] = byte_slip__i_;
			byte_slip__i_ = byte(data)[2];
			byte(data)[2] = byte(text)[2];
			byte(text)[2] = byte_slip__i_;
			byte_slip__i_ = byte(data)[3];
			byte(data)[3] = byte(text)[3];
			byte(text)[3] = byte_slip__i_;
			byte_slip__i_ = byte(data)[4];
			byte(data)[4] = byte(text)[4];
			byte(text)[4] = byte_slip__i_;
			byte_slip__i_ = byte(data)[5];
			byte(data)[5] = byte(text)[5];
			byte(text)[5] = byte_slip__i_;
			byte_slip__i_ = byte(data)[6];
			byte(data)[6] = byte(text)[6];
			byte(text)[6] = byte_slip__i_;
			byte_slip__i_ = byte(data)[7];
			byte(data)[7] = byte(text)[7];
			byte(text)[7] = byte_slip__i_;

			fxdata = *(struct fxdata_type *) (byte(data) + 8);
			*(struct fxdata_type *) (byte(data) + 8) =
			    *(struct fxdata_type *) (byte(text) + 8);
			*(struct fxdata_type *) (byte(text) + 8) = fxdata;
		    }
		}
	    }
	}
    }

    return status;
}
