/*
 * lxlist-l.k.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <e4.h>
#include <fd.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define lxlist(list) \
    ((struct lxlist_type *) (list))

int
_libx1f4i0_lxlist_k_logique(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE delete;
    int status;
    struct dxlist_type *dxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    delete = I_MODE(input[1]);

    size = dxlist_data->size;
    if (delete < -(X1f4_E4_C_MODE) (int) size
	|| !(delete < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck(context, size, delete);
    } else {
	X1f4_E4_C_MODE insert;
	struct dxlist_type *dxlist_text;
	unsigned mice;

	dxlist_text = I_LIST(input[2]);

	insert = I_MODE(input[3]);

	mice = dxlist_text->size + 1;
	if (insert < -(X1f4_E4_C_MODE) (int) mice
	    || !(insert < (X1f4_E4_C_MODE) (int) mice)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(context, mice, insert);
	} else {
	    void *text;

	    if (insert < 0) {
		insert += mice;
	    }

	    if (delete < 0) {
		delete += size;
	    }

	    status = _libx1f4i0_peek_l4list
		(dxlist_data->list, delete, &text);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(context, status);
	    } else {
		void *data;

		status = _libx1f4i0_push_l4list
		    (dxlist_text->list, insert, &data);
		if (status) {
		    status =
			_libx1f4i0_lxlist_stat_list(context, status);
		} else {
		    X1f4_E4_C_USER link;
		    unsigned sand;

		    sand = byte(text)[4] << 030 | byte(text)[5] << 020
			| byte(text)[6] << 010 | byte(text)[7];

		    link = I_USER(byte(text) + 8);

		    byte(data)[0] = byte(text)[0];
		    byte(data)[1] = byte(text)[1];
		    byte(data)[2] = byte(text)[2];
		    byte(data)[3] = byte(text)[3];
		    byte(data)[4] = byte(text)[4];
		    byte(data)[5] = byte(text)[5];
		    byte(data)[6] = byte(text)[6];
		    byte(data)[7] = byte(text)[7];

		    *(struct fxdata_type *) (byte(data) + 8) =
			*(struct fxdata_type *) (byte(text) + 8);

		    do {
			dxlist_text->size = mice + 0;

			if (~sand) {
			    int (*move) (void *, void *,
					 const struct excase_type *,
					 const struct excase_type *);
			    struct lxtext_type *lxtext_data;

			    lxtext_data =
				((struct lxtext_type *)
				 lxlist(context)->link_f.text) + sand;

			    move = lxtext_data->lxtype.move;
			    if (move) {
				status = move
				    (lxtext_data->lxtype.context, link,
				     lock_excase(dxlist_data),
				     lock_excase(dxlist_text));
				if (status) {
				    byte(data)[4] = ~0;
				    byte(data)[5] = ~0;
				    byte(data)[6] = ~0;
				    byte(data)[7] = ~0;
				    if (1) {
					break;
				    }
				}
			    }
			}

			status = _libx1f4i0_miss_l4list
			    (dxlist_data->list, delete);
			if (status) {
			    byte(text)[4] = ~0;
			    byte(text)[5] = ~0;
			    byte(text)[6] = ~0;
			    byte(text)[7] = ~0;

			    status = _libx1f4i0_lxlist_stat_list
				(context, status);
			} else {
			}

			dxlist_data->size = size - 1;
		    } while (0);
		}
	    }
	}
    }

    return status;
}
