/*
 * lxlist-l.d.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_d_logique(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	X1f4_E4_C_MODE mode;
	unsigned size;

	mode = I_MODE(input[1]);

	size = dxlist_data->size;
	if (mode < -(X1f4_E4_C_MODE) (int) size
	    || !(mode < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck
		(context, size, mode);
	} else {
	    void *data;

	    if (mode < 0) {
		mode += size;
	    }

	    status = _libx1f4i0_peek_l4list(dxlist_data->list, mode, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(context, status);
	    } else {
		do {
		    unsigned link;

		    link = byte(data)[4] << 030 | byte(data)[5] << 020
			| byte(data)[6] << 010 | byte(data)[7];
		    if (~link) {
			int (*free) (void *, void *, struct excase_type **,
				     const struct excase_type *);
			struct lxtext_type *lxtext_link;

			lxtext_link =
			    ((struct lxtext_type *)
			     ((struct lxlist_type *)
			      context)->link_f.text) + link;

			free = lxtext_link->lxtype.free;
			if (free) {
			    status = free
				(lxtext_link->lxtype.context,
				 I_USER(byte(data) + 8), NULL,
				 lock_excase(dxlist_data));
			    if (status) {
				break;
			    }
			}
		    }

		    status = _libx1f4i0_miss_l4list(dxlist_data->list, mode);
		    if (status) {
			status = _libx1f4i0_lxlist_stat_list
			    (context, status);
		    } else {
			dxlist_data->size = size - 1;
		    }
		} while (0);
	    }
	}
    }

    return status;
}
