/*
 * lxlist-f.n.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcall.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_LIST(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxlist_n_forward(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;

    dxlist_data = I_LIST(input[0]);

    lxlist_data = context;

    if (lock_exlist(dxlist_data)->call == 1) {
	if (dxlist_data->size) {
	    status = _libx1f4i0_lxlist_null_list(context, NULL, dxlist_data);
	} else {
	    status = 0;
	}
    } else {
	status = _libx1f4i0_lxlist_line_list(lxlist_data, input[0]);
	if (status) {
	} else {
	    status = _libx1f4i0_lxcall_near_node
		(&lxlist_data->link_v, &lxlist_data->link_e,
		 lxlist_data->link_t.datatype, dxlist_data);
	}
    }

    return status;
}
