/*
 * lxlist-f.i.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <l_list.h>
#include <lxcast.h>
#include <lxlist-close.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <nt.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_i_forward(void *context, void *output, void **input)
{
    int status;

    do {
	int (*copy) (void *, void *, void **, const void *,
		     const struct x1f4_nodelink_type *), type;
	struct dxlist_type *dxlist_data;
	struct lxlist_type *lxlist_data;
	struct lxtext_type *lxtext_data, *lxtext_link;
	struct x1f4_dxcast_type *dxcast_data;
	unsigned miss;
	void *data, *side;

	lxlist_data = context;

	dxlist_data = I_LIST(input[0]);

	dxcast_data = I_USER(input[1]);

	type = dxcast_data->type;

	lxtext_link = lxlist_data->link_f.text;

	lxtext_data = lxtext_link;

	close_frame(miss, lxtext_data);

	if (miss) {
	    copy = lxtext_data->lxtype.copy;
	    if (copy) {
		status = copy
		    (lxtext_data->lxtype.context, NULL, &side,
		     I_USER(&dxcast_data->data), lock_excase(dxlist_data));
		if (status) {
		    break;
		}
	    }
	} else {
	    copy = NULL;
	}

	if (0) {
	} else {
	    status = _libx1f4i0_head_l4list(dxlist_data->list, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
		if (copy) {
		    lxtext_data->lxtype.free
			(lxtext_data->lxtype.context, side,
			 NULL, lock_excase(dxlist_data));
		}
	    } else {
		unsigned link;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = miss ? lxtext_data - lxtext_link : ~0;

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		dxlist_data->size++;

		if (copy) {
		    l_USER(side, byte(data) + 8);
		} else {
		    copy_miss(byte(data) + 8, type, &dxcast_data->data);
		}
	    }
	}
    } while (0);

    return status;
}
