/*
 * lxlist-e.y.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcall.h>
#include <lxcast.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define lxlist(lxlist) \
    ((struct lxlist_type *) (lxlist))

int
_libx1f4i0_lxlist_post_data(void *lxlist, void *output, void *data)
{
    int status;

    do {
	struct lxtext_type *lxtext_data;
	unsigned link;
	void *cast;

	link = byte(data)[4] << 030 | byte(data)[5] << 020
	    | byte(data)[6] << 010 | byte(data)[7];

	if (~link) {
	    lxtext_data = lxlist(lxlist)->link_f.text;
	    lxtext_data += link;
	    if (lxtext_data->lxtype.lead) {
		status = _libx1f4i0_lxcall_post_node
		    (&lxlist(lxlist)->link_v, &lxlist(lxlist)->link_e,
		     &lxtext_data->lxtype, data, output);
		if (1) {
		    break;
		}
	    } else {
		if (lxtext_data->lxtype.code == X1f4_E4_TEXT) {
		    status = _libx1f4i0_lxcall_post_text
			(&lxlist(lxlist)->link_v, &lxlist(lxlist)->link_m,
			 &lxlist(lxlist)->link_e, byte(data) + 8, output);
		    if (1) {
			break;
		    }
		}
	    }
	}

	if (0) {
	} else {
	    unsigned type;

	    type = byte(data)[0] << 030 | byte(data)[1] << 020
		| byte(data)[2] << 010 | byte(data)[3];

	    if (X1f4_E4_LAST < type && type < X1f4_E4_CALL) {
		status = _libx1f4i0_lxlist_stat_lead(lxlist, type);
	    } else {
		status = lxlist(lxlist)->link_v.link
		    (lxlist(lxlist)->link_v.data, &cast,
		     sizeof(struct x1f4_dxcast_type));
		if (status) {
		    status = _libx1f4i0_lxlist_stat_link(lxlist);
		} else {
		    struct x1f4_dxcast_type *dxcast_data;

		    dxcast_data = cast;

		    l_USER(cast, output);

		    dxcast_data->call = 0;
		    dxcast_data->type = type;

		    copy_miss(&dxcast_data->data, type, byte(data) + 8);
		}
	    }
	}
    } while (0);

    return status;
}
