/*
 * lxlist-e.l.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcall.h>
#include <lxcast.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_fine_data(void *context, void *output, const void *data)
{
    int status;
    struct lxlist_type *lxlist_data;

    lxlist_data = context;

    do {
	struct lxtext_type *lxtext_data;
	unsigned link;
	void *cast;

	link = byte(data)[4] << 030 | byte(data)[5] << 020
	    | byte(data)[6] << 010 | byte(data)[7];

	if (~link) {
	    lxtext_data = lxlist_data->link_f.text;
	    lxtext_data += link;
	    if (lxtext_data->lxtype.lead) {
		status = _libx1f4i0_lxcall_post_node
		    (&lxlist_data->link_v, &lxlist_data->link_e,
		     &lxtext_data->lxtype, data, output);
		if (1) {
		    break;
		}
	    } else {
		if (lxtext_data->lxtype.code == X1f4_E4_TEXT) {
		    status = _libx1f4i0_lxcall_push_text
			(&lxlist_data->link_v, &lxlist_data->link_e,
			 byte(data) + 8, output);
		    if (1) {
			break;
		    }
		}
	    }
	}

	if (0) {
	} else {
	    unsigned type;

	    type = byte(data)[0] << 030 | byte(data)[1] << 020
		| byte(data)[2] << 010 | byte(data)[3];

	    if (0) {
	    } else {
		status = lxlist_data->link_v.link
		    (lxlist_data->link_v.data, &cast,
		     sizeof(struct x1f4_dxcast_type));
		if (status) {
		    status = _libx1f4i0_lxlist_stat_link(lxlist_data);
		} else {
		    struct x1f4_dxcast_type *dxcast_data;

		    dxcast_data = cast;

		    l_USER(cast, output);

		    dxcast_data->call = 0;
		    dxcast_data->type = type;

		    copy_miss(&dxcast_data->data, type, byte(data) + 8);
		}
	    }
	}
    } while (0);

    return status;
}
