/*
 * lxlist-e.3.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <trans.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxlist_copy_text(void *subtext, void *bqpp, void **copy,
			    const void *text, const struct excase_type *excase)
{
    int status;

    if (text == x1f4_c1_empty_string) {
	*copy = (char *) x1f4_c1_empty_string;

	status = 0;
    } else {
	unsigned size;

	size = strlen(text);

	if (size) {
	    struct lxlist_type *lxlist_data;

	    lxlist_data = subtext;

	    size++;

	    status = lxlist_data->link_m.link
		(lxlist_data->link_m.data, copy, size);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_link(lxlist_data);
	    } else {
		memcpy(*copy, text, size);
	    }
	} else {
	    *copy = (char *) x1f4_c1_empty_string;

	    status = 0;
	}
    }

    return status;
}
