/*
 * lxlist-d.p.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <retain.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_p_derived(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;
    unsigned size;

    dxlist_data = I_LIST(input[0]);

    lxlist_data = context;

    mode = I_MODE(input[1]);

    size = dxlist_data->size;
    if (mode < -(X1f4_E4_C_MODE) (int) size
	|| !(mode < (X1f4_E4_C_MODE) (int) size)) {
	status = _libx1f4i0_lxlist_stat_deck(lxlist_data, size, mode);
    } else {
	void *data, *list;

	if (mode < 0) {
	    mode += size;
	}

	list = dxlist_data->list;

	status = _libx1f4i0_peek_l4list(list, mode, &data);
	if (status) {
	    status = _libx1f4i0_lxlist_stat_list(context, status);
	} else {
	    status = _libx1f4i0_lxlist_post_data(lxlist_data, output, data);
	    if (status) {
	    } else {
#if __RETAIN_OBJECT_DATA__
# error not considered
#else
		unsigned link;

		link = byte(data)[4] << 030 | byte(data)[5] << 020
		    | byte(data)[6] << 010 | byte(data)[7];

		if (~link) {
		    struct lxtext_type *lxtext_data;

		    lxtext_data = lxlist_data->link_f.text;
		    lxtext_data += link;
		    if (lxtext_data->lxtype.lead) {
			status = lxtext_data->lxtype.free
			    (lxtext_data->lxtype.context,
			     I_USER(byte(data) + 8), NULL,
			     lock_excase(dxlist_data));
		    } else {
		    }
		}

		if (status) {
		} else {
		    status = _libx1f4i0_miss_l4list(list, mode);
		    if (status) {
			byte(data)[4] = ~0 >> 030;
			byte(data)[5] = ~0 >> 020;
			byte(data)[6] = ~0 >> 010;
			byte(data)[7] = ~0 >> 000;

			status = _libx1f4i0_lxlist_stat_list
			    (lxlist_data, status);
		    } else {
			dxlist_data->size = size - 1;
		    }
		}
#endif				/* __RETAIN_OBJECT_DATA__ */
	    }
	}
    }

    return status;
}
