/*
 * lxlist-d.e.1.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <copy.h>
#include <e4.h>
#include <fd.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxlist_e1derived(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxlist_type *lxlist_data;
    void **side;

    side = context;

    lxlist_data = *side;

    dxlist_data = I_LIST(input[1]);
    if (0) {
    } else {
	X1f4_E4_C_MODE mode;
	unsigned size;

	mode = I_MODE(input[2]);

	size = dxlist_data->size;
	if (mode < -(X1f4_E4_C_MODE) (int) size
	    || !(mode < (X1f4_E4_C_MODE) (int) size)) {
	    status = _libx1f4i0_lxlist_stat_deck(lxlist_data, size, mode);
	} else {
	    void *data;

	    if (mode < 0) {
		mode += size;
	    }

	    status = _libx1f4i0_peek_l4list(dxlist_data->list, mode, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
	    } else {
		unsigned call, type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		call = *((struct x1f4_function_type *) *(side + 1))->args;
		if (type != call) {
		    status = _libx1f4i0_lxlist_stat_type
			(lxlist_data, mode, type, call);
		} else {
		    struct fxdata_type fxdata;
		    unsigned link;

		    link = byte(data)[4] << 030 | byte(data)[5] << 020
			| byte(data)[6] << 010 | byte(data)[7];

		    fxdata = *(struct fxdata_type *) (byte(data) + 8);

		    status = _libx1f4i0_miss_l4list(dxlist_data->list, mode);
		    if (status) {
			status = _libx1f4i0_lxlist_stat_list
			    (lxlist_data, status);
		    } else {
			dxlist_data->size = size - 1;

			do {
			    if (~link) {
				struct lxtext_type *lxtext_data;

				lxtext_data = lxlist_data->link_f.text;
				lxtext_data += link;
				if (lxtext_data->lxtype.push) {
				    status = lxtext_data->lxtype.push
					(lxtext_data->lxtype.context,
					 *input, I_USER(&fxdata),
					 lock_excase(dxlist_data));
				    if (1) {
					break;
				    }
				}
			    }

			    copy_miss(*input, type, &fxdata);
			} while (0);
		    }
		}
	    }
	}
    }

    return status;
}
