/*
 * lxlist-c.a.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

int
_libx1f4i0_lxlist_a_centric(void *context, void *data, void **text)
{
    int status;
    struct lxlist_type *lxlist_data;
    struct x1f4_function_type *function_data;
    void *near;

    lxlist_data = context;

    function_data = data;

    function_data->function = _libx1f4i0_lxlist_a1centric;

    status = lxlist_data->link_v.link
	(lxlist_data->link_v.data, &near, sizeof(void *) << 1);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	void **side;

	side = near;

	*text = side;

	*side = lxlist_data;
	side[1] = function_data;
    }

    return status;
}
