/*
 * lxlist-b.v.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#if __CLIP_EXTRACT__
# define clip(none) \
    ((struct clip_type *) (none))
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
typedef struct clip_type {
    unsigned type;
    void *output;
} clip_type;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
static int clip_miss(void *, void *);
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
static int
clip_miss(void *clip, void *data)
{
    int status;
    unsigned type;

    type = byte(data)[0] << 030 | byte(data)[1] << 020 | byte(data)[2] << 010
	| byte(data)[3];
    if (type != X1f4_E4_BILL) {
	clip(clip)->type = type;

	status = 1;
    } else {
	status = 0;

	l_BILL(I_BILL(byte(data) + 8), clip(clip)->output);
    }

    return status;
}
#endif				/* __CLIP_EXTRACT__ */


int
_libx1f4i0_lxlist_v_class_b(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxtext_type *lxtext_data;

    lxtext_data = context;

    dxlist_data = I_LIST(input[1]);
    if (0) {
    } else {
	unsigned size;

	size = dxlist_data->size;
	if (!size) {
	    status = _libx1f4i0_lxlist_stat_null(lxtext_data->text);
	} else {
#if __CLIP_EXTRACT__
	    struct clip_type clip;
#else
	    void *data;
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
	    clip.output = input[0];
#endif				/* __CLIP_EXTRACT__ */

#if __CLIP_EXTRACT__
	    status = _libx1f4i0_nice_l4list
		(dxlist_data->list, &clip, clip_miss);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_call
		    (lxtext_data->text, size - 1, clip.type,
		     lxtext_data->lxtype.code, status);
	    } else {
		dxlist_data->size = size - 1;
	    }
#else
	    status = _libx1f4i0_ever_l4list(dxlist_data->list, &data);
	    if (status) {
		status =
		    _libx1f4i0_lxlist_stat_list(lxtext_data->text, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != X1f4_E4_BILL) {
		    status = _libx1f4i0_lxlist_stat_type
			(lxtext_data->text, size - 1, type,
			 lxtext_data->lxtype.code);
		} else {
		    X1f4_E4_C_BILL fast;

		    fast = I_BILL(byte(data) + 8);

		    --size;

# if defined __MISSING_SLIP_L_LIST__
		    status = _libx1f4i0_miss_l4list(dxlist_data->list, size);
# else
		    status = _libx1f4i0_slip_l4list(dxlist_data->list);
# endif				/* __MISSING_SLIP_L_LIST__ */
		    if (status) {
			status = _libx1f4i0_lxlist_stat_list
			    (lxtext_data->text, status);
		    } else {
			dxlist_data->size = size;

			l_BILL(fast, input[0]);
		    }
		}
	    }
#endif				/* __CLIP_EXTRACT__ */
	}
    }

    return status;
}
