/*
 * lxlist-b.t.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define lxtext(delete)			((struct lxtext_type *) (delete))

int
_libx1f4i0_lxlist_t_class_b(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	if (!dxlist_data->size) {
	    status = _libx1f4i0_lxlist_stat_null
		(lxtext(context)->text);
	} else {
	    void *data;

	    status = _libx1f4i0_ever_l4list(dxlist_data->list, &data);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_list
		    (lxtext(context)->text, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != X1f4_E4_BILL) {
		    struct lxtext_type *lxtext_data;

		    lxtext_data = context;

		    status = _libx1f4i0_lxlist_stat_type
			(lxtext_data->text, dxlist_data->size - 1, type,
			 lxtext_data->lxtype.code);
		} else {
		    l_BILL(I_BILL(byte(data) + 8), output);
		}
	    }
	}
    }

    return status;
}
