/*
 * lxlist-a.s.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <fd.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

int
_libx1f4i0_lxlist_fast_list(void *lxlist, void *dxlist)
{
    int status;
    struct lxlist_type *lxlist_data;
    struct x1f4_l4list_type l4list;
#if __TRANS_LIST_LX_DEFINITION__
#else
    struct x1f4_trans_type redtext;
#endif				/* __TRANS_LIST_LX_DEFINITION__ */

    lxlist_data = lxlist;

#if __TRANS_LIST_LX_DEFINITION__
#else
    redtext.context = lxlist_data->link_m.data;
#endif				/* __TRANS_LIST_LX_DEFINITION__ */

#if __TRANS_LIST_LX_DEFINITION__
#else
    redtext.free = lxlist_data->link_m.free;
    redtext.link = lxlist_data->link_m.link;
    redtext.mode = lxlist_data->link_m.mode;
#endif				/* __TRANS_LIST_LX_DEFINITION__ */

#if __TRANS_LIST_LX_DEFINITION__
    l4list.trans = &lxlist_data->link_m;
#else
    l4list.trans = &redtext;
#endif				/* __TRANS_LIST_LX_DEFINITION__ */

    l4list.size = sizeof(struct fxdata_type) + 8;

    l4list.quarter = QUARTER_FAST;
    l4list.rate = RATE_FAST;

    ((struct dxlist_type *) dxlist)->list = post_dxlist(dxlist);

    status = _libx1f4i0_fast_l4list
	(((struct dxlist_type *) dxlist)->list,
	 X1f4_L4LIST_FOUR_FRAME | X1f4_L4LIST_RATE_FRAME
	 | X1f4_L4LIST_TRANS_MASK, &l4list);
    if (status) {
	status = _libx1f4i0_lxlist_stat_list(lxlist_data, status);
    }

    return status;
}
