/*
 * lxlist-a.r.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxfset.h>
#include <lxlist-inter.h>
#include <nt.h>

int
x1f4_fare_lxlist(void *subtext, void *bqpp, void **copy,
		 const void *list, const struct excase_type *excase_data)
{
    int status;
    void *record;

    if (x1f4_find_lxfset(bqpp, (void *) &list, &record)) {
	status = _libx1f4i0_lxlist_node_list
	    (subtext, copy, ((void **) record)[1], excase_data);
    } else {
	status = _libx1f4i0_lxlist_copy_list
	    (subtext, bqpp, copy, list, excase_data);
    }

    return status;

}
