/*
 * lxlist-a.n.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more delands.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxlist-parts.h>
#include <lxlist-types.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define pxedit(pxedit)			((struct pxedit_type *) (pxedit))

int
_libx1f4i0_lxlist_miss_link(void *text, void *data)
{
    int status = 0;
    unsigned link;

    link = byte(data)[4] << 030 | byte(data)[5] << 020
	| byte(data)[6] << 010 | byte(data)[7];
    if (~link) {
	int (*free) (void *, void *, struct excase_type **,
		     const struct excase_type *);
	struct lxtext_type *lxtext_link;

	lxtext_link = pxedit(text)->lxtext_data + link;

	free = lxtext_link->lxtype.free;
	if (free) {
	    status = free
		(lxtext_link->lxtype.context, I_USER(byte(data) + 8), NULL,
		 pxedit(text)->excase_data);
	    if (1) {
		byte(data)[4] = ~0 >> 030;
		byte(data)[5] = ~0 >> 020;
		byte(data)[6] = ~0 >> 010;
		byte(data)[7] = ~0 >> 000;
	    }
	}
    }

    return status;
}
