/*
 * lxlist-a.e.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <e4.h>
#include <er.h>
#include <exerrors.h>
#include <l_list.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>

#define lxlist(lxlist) \
    ((struct lxlist_type *) (lxlist))

int
_libx1f4i0_lxlist_stat_call(void *lxlist, int mode, unsigned found,
			    unsigned expected, int error)
{
    int status;

    if (error == X1f4_L4LIST_CALL_ERROR) {
	status = _libx1f4i0_lxlist_stat_type(lxlist, mode, found, expected);
    } else {
	status = _libx1f4i0_lxlist_stat_list(lxlist, error);
    }

    return status;
}


#if 0
int
_libx1f4i0_lxlist_stat_copy(void *lxlist)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("cannot copy/link/move list for non self inclusion rules say so",
	      62);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
#endif				/* 0 */


int
_libx1f4i0_lxlist_stat_deck(void *lxlist, unsigned size, long mode)
{
    int status;

    if (size) {
	status = _libx1f4i0_lxlist_stat_time(lxlist, size, mode);
    } else {
	status = _libx1f4i0_lxlist_stat_null(lxlist);
    }

    return status;
}


int
_libx1f4i0_lxlist_stat_edit(void *lxlist, unsigned size, long mode, long land)
{
    if (land < mode) {
	long swap;

	swap = land;
	land = mode;
	mode = swap;
    }

    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("span (", 6);
    PUSH_LONG(mode);
    PUSH_DATA(" .. ", 4);
    PUSH_LONG(land);
    PUSH_DATA(") outside list (", 16);
    PUSH_BILL(size);
    PUSH_DATA(" long)", 6);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_flat(void *lxlist, int mode)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("numeric type expected for the ", 30);
    PUSH_MODE(mode + 1);
    PUSH_RANK(mode);
    PUSH_DATA(" list element", 13);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_free(void *lxlist)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxlist_stat_lead(void *lxlist, unsigned type)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("will not box non referable, non intrinsic object of type ", 57);
    PUSH_TRAP(type, lxlist(lxlist));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_link(void *lxlist)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxlist_stat_list(void *lxlist, int error)
{
    int status;

    if (error == X1f4_L4LIST_FREE_ERROR) {
	status = _libx1f4i0_lxlist_stat_free(lxlist);
    } else {
	if (error == X1f4_L4LIST_LINK_ERROR) {
	    status = _libx1f4i0_lxlist_stat_link(lxlist);
	} else {
	    if (error == X1f4_L4LIST_MODE_ERROR) {
		status = _libx1f4i0_lxlist_stat_mode(lxlist);
	    } else {
		if (error == X1f4_L4LIST_SIZE_ERROR) {
		    status = _libx1f4i0_lxlist_stat_size(lxlist);
		} else {
		    /*
		     * there are defined more list error conditions...
		     */
		    status = X1f4_EX_CRITICAL;
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxlist_stat_mode(void *lxlist)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxlist_stat_null(void *lxlist)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("empty list", 10);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_size(void *lxlist)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("list not empty", 14);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_time(void *lxlist, unsigned size, long mode)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("out of valid range (-", 21);
    PUSH_BILL(size);
    PUSH_DATA(" .. ", 4);
    PUSH_BILL(size - 1);
    PUSH_DATA(") index (", 9);
    PUSH_LONG(mode);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxlist_stat_type(void *lxlist, int mode, unsigned found,
			    unsigned expected)
{
    LINE_EEER(lxlist(lxlist)->link_e);

    PUSH_DATA("mismatched type (", 17);
    PUSH_TRAP(found, lxlist(lxlist));
    PUSH_DATA(" found, ", 8);
    PUSH_TRAP(expected, lxlist(lxlist));
    PUSH_DATA(" expected) for ", 15);
    PUSH_MODE(mode + 1);
    PUSH_RANK(mode);
    PUSH_DATA(" list element", 13);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
