/*
 * lxlist-a.b.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>

#include <exerrors.h>
#include <l_list.h>
#include <lxfset.h>
#include <lxlead.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <tcvset.h>

#define dxlist(list) \
    ((struct dxlist_type *) (list))
#define lxlist(list) \
    ((struct lxlist_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_copy_lxlist(void *subtext, void *bppp, void **copy,
		 const void *list, const struct excase_type *excase_data)
{
    int status;
    struct lxlist_type *lxlist_data;
    unsigned call;
    void *dxlist;

    lxlist_data = subtext;

    _libx1f4i0_call_l4list(&call);

    status = lxlist_data->link_m.link
	(lxlist_data->link_m.data, &dxlist,
	 __struct_dxlist_type_alloc_size__ + call);
    if (status) {
	status = _libx1f4i0_lxlist_stat_link(lxlist_data);
    } else {
	void *bqpp;

	do {
	    void *record;

	    if (bppp) {
		bqpp = bppp;
	    } else {
		status = x1f4_init_lxfset(&bqpp);
		if (status) {
		    status = _libx1f4i0_lxlist_stat_link(lxlist_data);
		    if (1) {
			break;
		    }
		}
	    }

	    status = x1f4_post_lxfset(bqpp, (void *) &list, &record);
	    if (status) {
		status = _libx1f4i0_lxlist_stat_link(lxlist_data);
		if (1) {
		    break;
		}
	    } else {
		void *pset;
		const void *text;

		dxlist = pick_dxlist(dxlist);

		{
		    {
			void **node;

			node = record;
			node[0] = (void *) list;
			node[1] = dxlist;
		    }
		}

		lock_excase(dxlist)->nodetype_data = lxlist_data->link_n.node;

		lock_excase(dxlist)->slip = NULL;

		lock_exlist(dxlist)->call = 1;

		_libx1f4i0_init_tcvset(&pset, &text);

		status = tccase(text)->push
		    (&pset, &text, excase_data, (void *) &lxlist_data->link_m);
		if (status) {
		    status = X1f4_EX_CRITICAL;

		    _libx1f4i0_fini_tcvset
			(&pset, &text, (void *) &lxlist_data->link_m);
		} else {
		    void *becca[6];

		    lock_exlist(dxlist)->pset = pset;
		    lock_exlist(dxlist)->text = text;

		    becca[0] = subtext;
		    becca[1] = NULL;
		    becca[2] = dxlist;
		    becca[3] = bqpp;
		    becca[4] = &lxlist_data->link_m;
		    becca[5] = NULL;

		    status = _libx1f4i0_lxlist_fast_list(subtext, dxlist);
		    if (status) {
		    } else {
			status = _libx1f4i0_line_l4list
			    (dxlist(dxlist)->list, dxlist(list)->list,
			     _libx1f4i0_lxlist_copy_link,
			     _libx1f4i0_lxlist_free_link, becca);
			if (status) {
			    status = _libx1f4i0_lxlist_stat_list
				(lxlist_data, status);

			    _libx1f4i0_flat_l4list
				(((struct dxlist_type *) dxlist)->list);
			}
		    }
		    if (status) {
			x1f4_lose_lxlead(becca[5], &lxlist_data->link_m);

			_libx1f4i0_fini_tcvset
			    (&pset, &text, (void *) &lxlist_data->link_m);
		    } else {
			dxlist(dxlist)->size = dxlist(list)->size;

			status = x1f4_beta_lxlead
			    (bqpp, becca[5], &lxlist_data->link_m);
			if (status) {
			    _libx1f4i0_lxlist_side_list(lxlist_data, dxlist);
			} else {
			    *copy = dxlist;
			}

			dxlist = NULL;
		    }
		}
	    }
	} while (0);

	if (bqpp) {
	    if (bppp) {
	    } else {
		int excess;

		excess = x1f4_fini_lxfset(&bqpp);
		if (excess) {
		    excess = _libx1f4i0_lxlist_stat_free(lxlist_data);

		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}

	if (dxlist) {
	    lxlist_data->link_m.free
		(lxlist_data->link_m.data, lock_cxlist(dxlist));
	}
    }

    return status;
}
