/*
 * lxlist-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlist-config.h>

#include <stddef.h>
#include <string.h>

#include <af.h>
#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxlist-defs.h>
#include <lxlist-inter.h>
#include <lxlist-types.h>
#include <srand.h>

#define MAKE_SINGLE(a, b)		a

#define may_include(lxtype)		0

/*
 * TODO
 *
 * rename this here and elsewhere, it is lf_e_ now
 */
#define l_d_type_post			2

#define l_e_type_post			3

/*
 * TODO
 *
 * rename this here and elsewhere, it is lb_e_ now
 */
#define l_v_type_post			2

#define l________size \
    sizeof(struct x1f4_linetext_type)

#define screen(screen) \
    ((struct screen_type *) (screen))

#define fm_size(none) \
    sizeof(struct lxmiss_type)

#define fb_size()			1

extern const struct x1f4_eelookup_type _x1f4_type_lookup;

static int init_list(struct lxlist_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxlist_type *, unsigned,
		     const struct screen_type *, void *, void *, void **,
		     void **);
static int line_list(struct lxlist_type *, unsigned,
		     const struct screen_type *);
static int line_sail(struct lxlist_type *, const struct screen_type *,
		     struct x1f4_linetext_type **, struct lxtext_type *,
		     const struct lxtype_type *, void **, void **);
static int line_text(struct lxlist_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_list(struct lxlist_type *, unsigned,
		     const struct screen_type *);
static int pick_miss(unsigned *, unsigned *, unsigned *, unsigned,
		     const struct screen_type *);

static void line_amix(v_case_args_____0);
static void line_aset(u_case_args_____0);
static void line_asub(u_case_args_____0);
static void line_bmap(u_case_args_____0);
static void line_bmix(v_case_args_____0);
static void line_bset(v_case_args_____0);
static void line_bsub(u_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_cmap(u_case_args_____0);
static void line_csub(u_case_args_____0);
static void line_dfix(u_case_args_____0);
static void line_dmix(v_case_args_____0);
static void line_dset(u_case_args_____0);
static void line_emap(u_case_args_____0);
static void line_emix(v_case_args_____0);
static void line_eset(u_case_args_____0);
static void line_esub(u_case_args_____0);
static void line_eway(u_case_args_____0);
static void line_gway(u_case_args_____0);
static void line_hmix(v_case_args_____0);
static void line_hset(u_case_args_____0);
static void line_imap(u_case_args_____0);
static void line_imix(v_case_args_____0);
static void line_iset(u_case_args_____0);
static void line_kfix(u_case_args_____0);
static void line_lfar(v_case_args_____0);
static void line_lfix(u_case_args_____0);
static void line_lmap(u_case_args_____0);
static void line_lset(v_case_args_____0);
static void line_lway(v_case_args_____0);
static void line_mfix(u_case_args_____0);
static void line_nfix(v_case_args_____0);
static void line_nset(u_case_args_____0);
static void line_ofix(u_case_args_____0);
static void line_pfar(u_case_args_____0);
static void line_pmap(u_case_args_____0);
static void line_pmix(v_case_args_____0);
static void line_pset(u_case_args_____0);
static void line_pway(u_case_args_____0);
static void line_qmix(v_case_args_____0);
static void line_qset(u_case_args_____0);
static void line_rfix(u_case_args_____0);
static void line_rmix(v_case_args_____0);
static void line_rset(u_case_args_____0);
static void line_rway(u_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_smap(v_case_args_____0);
static void line_sset(u_case_args_____0);
static void line_sway(u_case_args_____0);
static void line_tfix(u_case_args_____0);
static void line_tmap(u_case_args_____0);
static void line_tmix(v_case_args_____0);
static void line_tset(u_case_args_____0);
static void line_uset(u_case_args_____0);
static void line_vmix(v_case_args_____0);
static void line_wfix(u_case_args_____0);
static void line_xmix(v_case_args_____0);
static void line_zfix(u_case_args_____0);
static void line_zmix(v_case_args_____0);

static const char fl_setf[] = "l_set", *const side_f[] = {
/* *INDENT-OFF* */
    fl_setf
/* *INDENT-ON* */
};
static const struct line_type auto_line[] = {
/* *INDENT-OFF* */
#define l_assemble_count		0
    {	{	"l_assemble",
		_libx1f4i0_lxlist_a_centric,	0,
		NULL,				l_assemble_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						10		},
	line_asub,							},
#define l_assemble_reach		(0 + l_assemble_count)
#define l_bill_count			2
    {	{	"l_bill",
		_libx1f4i0_lxlist_b_centric,	X1f4_E4_VOID,
		NULL,				l_bill_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						6		},
	line_bsub,							},
#define l_bill_reach			(l_assemble_reach + l_bill_count)
#define l_collect_count			2
    {	{	"l_collect",
		_libx1f4i0_lxlist_c_centric,	X1f4_E4_VOID,
		NULL,				l_collect_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						9		},
	line_csub,							},
#define l_collect_reach			(l_bill_reach + l_collect_count)
#define l_effect_count			0
    {	{	"l_effect",
		_libx1f4i0_lxlist_e_centric,	0,
		NULL,				l_effect_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						8		},
	line_esub,							},
#define l_effect_reach			(l_collect_reach + l_effect_count)
#define l_extract_count			3
    {	{	"l_extract",
		_libx1f4i0_lxlist_e_derived,	X1f4_E4_VOID,
		NULL,				l_extract_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_SLIP_LIST | X1f4_E4_TEXT_LINK,
						9		},
	line_eway,							},
#define l_extract_reach \
    (l_effect_reach + (l_extract_count << 1))
#define l_get_count			3
    {	{	"l_get",
		_libx1f4i0_lxlist_g_derived,	X1f4_E4_VOID,
		NULL,				l_get_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_SLIP_LIST | X1f4_E4_TEXT_LINK,
						5		},
	line_gway,							}
#define l_get_reach			(l_extract_reach + (l_get_count << 1))
/* *INDENT-ON* */
#define auto_line_count			l_get_reach
}, call_line[] = {
/* *INDENT-OFF* */
#define l_new_count			1
    {	{	"l_new",
		_libx1f4i0_lxlist_n_forward,	X1f4_E4_VOID,
		NULL,				l_new_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_nset,							}
#define l_new_reach			(0 + (l_new_count << 1))
/* *INDENT-ON* */
#define call_line_count			l_new_reach
}, ever_line[] = {
/* *INDENT-OFF* */
#define l_set_count			2
    {	{	fl_setf,
		_libx1f4i0_lxlist_s_forward,	0,
		NULL,				l_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_sset,							}
#define l_set_reach			(0 + (l_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			l_set_reach
}, fail_line[] = {
/* *INDENT-OFF* */
#define l_append_count			2
    {	{	"l_append",
		_libx1f4i0_lxlist_a_forward,	X1f4_E4_VOID,
		NULL,				l_append_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_aset,							},
#define l_append_reach			(0 + l_append_count)
#define l_bind_count			3
    {	{	"l_bind",
		_libx1f4i0_lxlist_b_pending,	X1f4_E4_VOID,
		NULL,				l_bind_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_bmap,							},
#define l_bind_reach			(l_append_reach + l_bind_count)
#define l_head_count			1
    {	{	"l_head",
		_libx1f4i0_lxlist_h_forward,	X1f4_E4_CASE,
		NULL,				l_head_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_hset,							},
#define l_head_reach			(l_bind_reach + l_head_count)
#define l_insert_count			2
    {	{	"l_insert",
		_libx1f4i0_lxlist_i_forward,	X1f4_E4_VOID,
		NULL,				l_insert_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_iset,							},
#define l_insert_reach			(l_head_reach + l_insert_count)
#define l_link_count			3
    {	{	"l_link",
		_libx1f4i0_lxlist_l_pending,	X1f4_E4_VOID,
		NULL,				l_link_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_lmap,							},
#define l_link_reach			(l_insert_reach + l_link_count)
#define l_pick_count			2
    {	{	"l_pick",
		_libx1f4i0_lxlist_p_derived,	X1f4_E4_CASE,
		NULL,				l_pick_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_pway,							},
#define l_pick_reach			(l_link_reach + l_pick_count)
#define l_push_count			3
    {	{	"l_push",
		_libx1f4i0_lxlist_p_forward,	X1f4_E4_VOID,
		NULL,				l_push_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_pset,							},
#define l_push_reach			(l_pick_reach + l_push_count)
#define l_query_count			2
    {	{	"l_query",
		_libx1f4i0_lxlist_q_forward,	X1f4_E4_CASE,
		NULL,				l_query_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_qset,							},
#define l_query_reach			(l_push_reach + l_query_count)
#define l_replace_count			3
    {	{	"l_replace",
		_libx1f4i0_lxlist_r_logique,	X1f4_E4_VOID,
		NULL,				l_replace_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_rfix,							},
#define l_replace_reach			(l_query_reach + l_replace_count)
#define l_tail_count			1
    {	{	"l_tail",
		_libx1f4i0_lxlist_t_forward,	X1f4_E4_CASE,
		NULL,				l_tail_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_tset,							},
#define l_tail_reach			(l_replace_reach + l_tail_count)
#define lb_pick_count			1
    {	{	"lb_pick",
		_libx1f4i0_lxlist_p_sequent,	X1f4_E4_CASE,
		NULL,				lb_pick_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pfar,							},
#define lb_pick_reach			(l_tail_reach + lb_pick_count)
#define lb_query_count			1
    {	{	"lb_query",
		_libx1f4i0_lxlist_t_forward,	X1f4_E4_CASE,
		NULL,				lb_query_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_tset,							},
#define lb_query_reach			(lb_pick_reach + lb_query_count)
#define lf_pick_count			1
    {	{	"lf_pick",
		_libx1f4i0_lxlist_p_pending,	X1f4_E4_CASE,
		NULL,				lf_pick_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pmap,							},
#define lf_pick_reach			(lb_query_reach + lf_pick_count)
#define lf_query_count			1
    {	{	"lf_query",
		_libx1f4i0_lxlist_h_forward,	X1f4_E4_CASE,
		NULL,				lf_query_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_hset,							}
#define lf_query_reach			(lf_pick_reach + lf_query_count)
/* *INDENT-ON* */
#define fail_line_count			lf_query_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define l_class_count			1
    {	{	"l_class",
		_libx1f4i0_lxlist_c_pending,	X1f4_E4_VOID,
		NULL,				l_class_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cmap,							},
#define l_class_reach			l_class_count
#define l_clear_count			1
    {	{	"l_clear",
		_libx1f4i0_lxlist_z_logique,	X1f4_E4_VOID,
		NULL,				l_clear_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_zfix,							},
#define l_clear_reach			(l_class_reach + l_clear_count)
#define l_copy_count			2
    {	{	"l_copy",
		_libx1f4i0_lxlist_c_logique,	X1f4_E4_VOID,
		NULL,				l_copy_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_cfix,							},
#define l_copy_reach			(l_clear_reach + l_copy_count)
#define l_delete_count			2
    {	{	"l_delete",
		_libx1f4i0_lxlist_d_logique,	X1f4_E4_VOID,
		NULL,				l_delete_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_dfix,							},
#define l_delete_reach			(l_copy_reach + l_delete_count)
#define l_down_count			2
    {	{	"l_down",
		_libx1f4i0_lxlist_d_forward,	X1f4_E4_VOID,
		NULL,				l_down_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_dset,							},
#define l_down_reach			(l_delete_reach + l_down_count)
#define l_edit_count			3
    {	{	"l_edit",
		_libx1f4i0_lxlist_e_forward,	X1f4_E4_VOID,
		NULL,				l_edit_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_eset,							},
#define l_edit_reach			(l_down_reach + l_edit_count)
#define l_erase_count			3
    {	{	"l_erase",
		_libx1f4i0_lxlist_e_pending,	X1f4_E4_VOID,
		NULL,				l_erase_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_emap,							},
#define l_erase_reach			(l_edit_reach + l_erase_count)
#define l_id_count			2
    {	{	"l_id",
		_libx1f4i0_lxlist_i_pending,	X1f4_E4_MODE,
		NULL,				l_id_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_imap,							},
#define l_id_reach			(l_erase_reach + l_id_count)
#define l_length_count			1
    {	{	"l_length",
		_libx1f4i0_lxlist_l_logique,	X1f4_E4_MODE,
		NULL,				l_length_count,
		0,
						8		},
	line_lfix,							},
#define l_length_reach			(l_id_reach + l_length_count)
#define l_post_count			4
    {	{	"l_post",
		_libx1f4i0_lxlist_k_logique,	X1f4_E4_VOID,
		NULL,				l_post_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_kfix,							},
#define l_post_reach			(l_length_reach + l_post_count)
#define l_move_count			3
    {	{	"l_move",
		_libx1f4i0_lxlist_m_logique,	X1f4_E4_VOID,
		NULL,				l_move_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_mfix,							},
#define l_move_reach			(l_post_reach + l_move_count)
#define l_offset_count			2
    {	{	"l_offset",
		_libx1f4i0_lxlist_o_logique,	X1f4_E4_VOID,
		NULL,				l_offset_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_ofix,							},
#define l_offset_reach			(l_move_reach + l_offset_count)
#define l_rand_count			1
    {	{	"l_rand",
		_libx1f4i0_lxlist_r_derived,	X1f4_E4_VOID,
		NULL,				l_rand_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_rway,							},
#define l_rand_reach			(l_offset_reach + l_rand_count)
#define l_reverse_count			1
    {	{	"l_reverse",
		_libx1f4i0_lxlist_r_forward,	X1f4_E4_VOID,
		NULL,				l_reverse_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_rset,							},
#define l_reverse_reach			(l_rand_reach + l_reverse_count)
#define l_short_count			1
    {	{	"l_short",
		_libx1f4i0_lxlist_s_derived,	X1f4_E4_VOID,
		NULL,				l_short_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_sway,							},
#define l_short_reach			(l_reverse_reach + l_short_count)
#define l_spin_count			3
    {	{	"l_spin",
		_libx1f4i0_lxlist_s_logique,	X1f4_E4_VOID,
		NULL,				l_spin_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_sfix,							},
#define l_spin_reach			(l_short_reach + l_spin_count)
#define l_swap_count			2
    {	{	"l_swap",
		_libx1f4i0_lxlist_w_logique,	X1f4_E4_VOID,
		NULL,				l_swap_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_wfix,							},
#define l_swap_reach			(l_spin_reach + l_swap_count)
#define l_trade_count			4
    {	{	"l_trade",
		_libx1f4i0_lxlist_t_logique,	X1f4_E4_VOID,
		NULL,				l_trade_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_tfix,							},
#define l_trade_reach			(l_swap_reach + l_trade_count)
#define l_type_count			2
    {	{	"l_type",
		_libx1f4i0_lxlist_t_pending,	X1f4_E4_TEXT,
		NULL,				l_type_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_tmap,							},
#define l_type_reach			(l_trade_reach + l_type_count)
#define l_up_count			2
    {	{	"l_up",
		_libx1f4i0_lxlist_u_forward,	X1f4_E4_VOID,
		NULL,				l_up_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_uset,							}
#define l_up_reach			(l_type_reach + l_up_count)
/* *INDENT-ON* */
#define slip_line_count			l_up_reach
};
static const struct link_type cast_line[] = {
/* *INDENT-OFF* */
#define l_q__class			4
#define l_q__count			2
    {	{	"l_q_",
		NULL,				0,
		NULL,				l_q__count,
		X1f4_E4_TEXT_LINK,		l_q__class	},
	line_qmix,							},
#define l_q__reach			(0 + l_q__count)
#define l_q__trans			(0 + l_q__class)
#define lb_q__class			5
#define lb_q__count			1
    {	{	"lb_q_",
		NULL,				0,
		NULL,				lb_q__count,
		X1f4_E4_TEXT_LINK,		lb_q__class	},
	line_tmix,							},
#define lb_q__reach			(l_q__reach + lb_q__count)
#define lb_q__trans			(l_q__trans + lb_q__class)
#define lf_q__class			5
#define lf_q__count			1
    {	{	"lf_q_",
		NULL,				0,
		NULL,				lf_q__count,
		X1f4_E4_TEXT_LINK,		lf_q__class	},
	line_hmix,							}
#define lf_q__reach			(lb_q__reach + lf_q__count)
#define lf_q__trans			(lb_q__trans + lf_q__class)
/* *INDENT-ON* */
#define cast_line_class			lf_q__trans
#define cast_line_count			lf_q__reach
#define cast_line_shift \
    sizeof(cast_line) / sizeof(struct link_type)
}, fast_line[] = {
/* *INDENT-OFF* */
#define l_e__class			4
#define l_e__count			3
    {	{	"l_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				l_e__count,
		0,				l_e__class	},
	line_emix,							},
#define l_e__reach			(0 + l_e__count)
#define l_e__trans			(0 + l_e__class)
#define l_p__class			4
#define l_p__count			3
    {	{	"l_p_",
		NULL,				X1f4_E4_VOID,
		NULL,				l_p__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						l_p__class	},
	line_pmix,							},
#define l_p__reach			(l_e__reach + l_p__count)
#define l_p__trans			(l_e__trans + l_p__class)
#define l_r__class			4
#define l_r__count			3
    {	{	"l_r_",
		NULL,				X1f4_E4_VOID,
		NULL,				l_r__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						l_r__class	},
	line_rmix,							},
#define l_r__reach			(l_p__reach + l_r__count)
#define l_r__trans			(l_p__trans + l_r__class)
#define l_s__class			4
#define l_s__count			2
    {	{	"l_s_",
		_libx1f4i0_lxlist_s_pending,	X1f4_E4_MODE,
		NULL,				l_s__count,
		X1f4_E4_TEXT_LINK,		l_s__class	},
	line_smap,							},
#define l_s__reach			(l_r__reach + l_s__count)
#define l_s__trans			(l_r__trans + l_s__class)
#define lb_e__class			5
#define lb_e__count			2
    {	{	"lb_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				lb_e__count,
		0,				lb_e__class	},
	line_vmix,							},
#define lb_e__reach			(l_s__reach + lb_e__count)
#define lb_e__trans			(l_s__trans + lb_e__class)
#define lb_p__class			5
#define lb_p__count			2
    {	{	"lb_p_",
		NULL,				X1f4_E4_VOID,
		NULL,				lb_p__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						lb_p__class	},
	line_amix,							},
#define lb_p__reach			(lb_e__reach + lb_p__count)
#define lb_p__trans			(lb_e__trans + lb_p__class)
#define lf_e__class			5
#define lf_e__count			2
    {	{	"lf_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				lf_e__count,
		0,				lf_e__class	},
	line_dmix,							},
#define lf_e__reach			(lb_p__reach + lf_e__count)
#define lf_e__trans			(lb_p__trans + lf_e__class)
#define lf_p__class			5
#define lf_p__count			2
    {	{	"lf_p_",
		NULL,				X1f4_E4_VOID,
		NULL,				lf_p__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						lf_p__class	},
	line_imix,							}
#define lf_p__reach			(lf_e__reach + lf_p__count)
#define lf_p__trans			(lf_e__trans + lf_p__class)
/* *INDENT-ON* */
#define fast_line_class			lf_p__trans
#define fast_line_count			lf_p__reach
#define fast_line_shift \
    sizeof(fast_line) / sizeof(struct link_type)
}, long_line[] = {
/* *INDENT-OFF* */
#define l_b__class			4
#define l_b__count			3
    {	{	"l_b_",
		_libx1f4i0_lxlist_b_forward,	X1f4_E4_VOID,
		NULL,				l_b__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						l_b__class	},
	line_bset,							},
#define l_b__reach			(0 + l_b__count)
#define l_b__trans			(0 + l_b__class)
#define l_l__class			4
#define l_l__count			3
    {	{	"l_l_",
		_libx1f4i0_lxlist_l_forward,	X1f4_E4_VOID,
		NULL,				l_l__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						l_l__class	},
	line_lset,							},
#define l_l__reach			(l_b__reach + l_l__count)
#define l_l__trans			(l_b__trans + l_l__class)
#define lb_l__class			5
#define lb_l__count			2
    {	{	"lb_l_",
		_libx1f4i0_lxlist_l_derived,	X1f4_E4_VOID,
		NULL,				lb_l__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						lb_l__class	},
	line_lway,							},
#define lb_l__reach			(l_l__reach + lb_l__count)
#define lb_l__trans			(l_l__trans + lb_l__class)
#define lf_l__class			5
#define lf_l__count			2
    {	{	"lf_l_",
		_libx1f4i0_lxlist_l_sequent,	X1f4_E4_VOID,
		NULL,				lf_l__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						lf_l__class	},
	line_lfar,							}
#define lf_l__reach			(lb_l__reach + lf_l__count)
#define lf_l__trans			(lb_l__trans + lf_l__class)
/* *INDENT-ON* */
#define long_line_class			lf_l__trans
#define long_line_count			lf_l__reach
#define long_line_shift \
    sizeof(long_line) / sizeof(struct link_type)
}, past_line[] = {
/* *INDENT-OFF* */
#define l_x__class			4
#define l_x__count			2
    {	{	"l_x_",
		NULL,				0,
		NULL,				l_x__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						l_x__class	},
	line_xmix,							},
#define l_x__reach			(0 + l_x__count)
#define l_x__trans			(0 + l_x__class)
#define lb_x__class			5
#define lb_x__count			1
    {	{	"lb_x_",
		NULL,				0,
		NULL,				lb_x__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						lb_x__class	},
	line_zmix,							},
#define lb_x__reach			(l_x__reach + lb_x__count)
#define lb_x__trans			(l_x__trans + lb_x__class)
#define lf_x__class			5
#define lf_x__count			1
    {	{	"lf_x_",
		NULL,				0,
		NULL,				lf_x__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						lf_x__class	},
	line_bmix,							}
#define lf_x__reach			(lb_x__reach + lf_x__count)
#define lf_x__trans			(lb_x__trans + lf_x__class)
/* *INDENT-ON* */
#define past_line_class			lf_x__trans
#define past_line_count			lf_x__reach
#define past_line_shift \
    sizeof(past_line) / sizeof(struct link_type)
}, spin_line[] = {
/* *INDENT-OFF* */
#define l_n__count			2
    {	{	"l_n_",
		_libx1f4i0_lxlist_n_logique,	0,
		NULL,				l_n__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_nfix,							}
#define l_n__reach			(0 + l_n__count)
/* *INDENT-ON* */
#define spin_line_class			(spin_line_shift * 4)
#define spin_line_count			l_n__reach
#define spin_line_shift \
    sizeof(spin_line) / sizeof(struct link_type)
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_list(struct lxlist_type *lxlist_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    if (bits & AUTOLINK_LINK) {
	lxlist_data->link_v.data = screen_data->link_v.data;
	lxlist_data->link_v.free = screen_data->link_v.free;
	lxlist_data->link_v.link = screen_data->link_v.link;
	lxlist_data->link_v.mode = screen_data->link_v.mode;
	lxlist_data->link_v.pick = screen_data->link_v.pick;
	lxlist_data->link_v.slip = screen_data->link_v.slip;
    } else {
	bits &= ~EVERLINK_SLIP;

	lxlist_data->link_v.data = NULL;
	lxlist_data->link_v.free = NULL;
	lxlist_data->link_v.link = NULL;
	lxlist_data->link_v.mode = NULL;
	lxlist_data->link_v.pick = NULL;
	lxlist_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxlist_data->link_w.data = screen_data->link_w.data;
	lxlist_data->link_w.free = screen_data->link_w.free;
	lxlist_data->link_w.link = screen_data->link_w.link;
	lxlist_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxlist_data->link_w.data = NULL;
	lxlist_data->link_w.free = _x1f4_e4_free_data;
	lxlist_data->link_w.link = _x1f4_e4_link_data;
	lxlist_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & EELOOKUP_LINK) {
	lxlist_data->trap_e.eelookup_data = screen_data->trap_e.eelookup_data;
    } else {
	lxlist_data->trap_e.eelookup_data = &_x1f4_type_lookup;
    }

    if (bits & MISSBAIL_LINK) {
	lxlist_data->link_r.call = screen_data->link_r.call;
	lxlist_data->link_r.fine = screen_data->link_r.fine;
	lxlist_data->link_r.miss = screen_data->link_r.miss;
	lxlist_data->link_r.text = screen_data->link_r.text;
    } else {
	lxlist_data->link_r.call = NULL;
	lxlist_data->link_r.fine = NULL;
	lxlist_data->link_r.miss = NULL;
    }

    if (bits & RESOURCE_LINK) {
	lxlist_data->link_m.data = screen_data->link_m.data;
	lxlist_data->link_m.free = screen_data->link_m.free;
	lxlist_data->link_m.link = screen_data->link_m.link;
	lxlist_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxlist_data->link_m.data = NULL;
	lxlist_data->link_m.free = _x1f4_e4_free_data;
	lxlist_data->link_m.link = _x1f4_e4_link_data;
	lxlist_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxlist_data->link_e.data = screen_data->link_e.data;
	lxlist_data->link_e.line = screen_data->link_e.line;
	lxlist_data->link_e.post = screen_data->link_e.post;
	lxlist_data->link_e.push = screen_data->link_e.push;
    } else {
	lxlist_data->link_e.data = NULL;
	lxlist_data->link_e.line = NULL;
	lxlist_data->link_e.post = NULL;
	lxlist_data->link_e.push = NULL;
    }

    if (bits & TRANSFER_LINK) {
	lxlist_data->link_o.fine = screen_data->link_o.fine;
    } else {
	lxlist_data->link_o.fine = NULL;
    }

    return link_list(lxlist_data, bits, screen_data);
}


static int
line_data(struct lxlist_type *lxlist_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void *text,
	  void **args, void **dana)
{
    struct lxtext_type *lxtext_data;
    const struct lxtype_type *lxtype_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    lxtype_data = screen_data->link_t.data;

    linetext_data = data;
    lxtext_data = text;

    lxtype_data--;

    _x1f4_type_effect(&lxtext_data->lxtype, X1f4_E4_CALL);
    lxtext_data->text = lxlist_data;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	unsigned flags;

	lxtext_data++;

	lxtype_data++;

	line_sail
	    (lxlist_data, screen_data, &linetext_data, lxtext_data,
	     lxtype_data, args, dana);

	flags = lxtype_data->flags;

	if (flags & X1f4_LX_TYPE_EXCEPT) {
	    continue;
	}

	if (1) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, fast_line_shift, fast_line);
	}
	if (bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, cast_line_shift, cast_line);
	}
	if (bits & AUTOLINK_LINK
	    || (!lxtype_data->lead && lxtype_data->code != X1f4_E4_TEXT)) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, past_line_shift, past_line);
	}

	if (flags & LINK_ACCESS) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, long_line_shift, long_line);
	}
	if (flags & POST_ACCESS && bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, spin_line_shift, spin_line);
	}
    }

    return 0;
}


static int
line_list(struct lxlist_type *lxlist_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxlist_data->link_t.datatype[0].context = lxlist_data;

    lxlist_data->link_t.datatype[0].flat = _libx1f4i0_lxlist_flat_list;
    lxlist_data->link_t.datatype[0].lead = _libx1f4i0_lxlist_lead_list;
    lxlist_data->link_t.datatype[0].line = _libx1f4i0_lxlist_line_list;
    lxlist_data->link_t.datatype[0].link = _libx1f4i0_lxlist_link_list;
    lxlist_data->link_t.datatype[0].name = "list";
    lxlist_data->link_t.datatype[0].shut = _libx1f4i0_lxlist_flat_list;
    lxlist_data->link_t.datatype[0].slip = _libx1f4i0_lxlist_slip_list;
    lxlist_data->link_t.datatype[0].size = 4;
    lxlist_data->link_t.datatype[0].type = screen_data->link_l.type;

    lxlist_data->link_t.datatype[1].context = NULL;

    lxlist_data->link_t.datatype[1].flat = NULL;
    lxlist_data->link_t.datatype[1].lead = NULL;
    lxlist_data->link_t.datatype[1].line = NULL;
    lxlist_data->link_t.datatype[1].link = NULL;
    lxlist_data->link_t.datatype[1].name = NULL;
    lxlist_data->link_t.datatype[1].shut = NULL;
    lxlist_data->link_t.datatype[1].slip = NULL;
    lxlist_data->link_t.datatype[1].size = 0;
    lxlist_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_sail(struct lxlist_type *lxlist_data,
	  const struct screen_type *screen_data,
	  struct x1f4_linetext_type **linetext,
	  struct lxtext_type *lxtext_data,
	  const struct lxtype_type *lxtype_data, void **subtext, void **dana)
{
    int code;
    struct x1f4_linetext_type *linetext_data;

    code = lxtype_data->code;

    linetext_data = *linetext;

    lxtext_data->lxtype = *lxtype_data;
    lxtext_data->text = lxlist_data;

    if (code == screen_data->link_l.type) {
	lxlist_data->link_n.node = &lxtext_data->lxtype;
    } else {
	if (code == X1f4_E4_TEXT) {
	    lxtext_data->lxtype.context = lxlist_data;

	    lxtext_data->lxtype.copy = _libx1f4i0_lxlist_copy_text;
	    lxtext_data->lxtype.free = _libx1f4i0_lxlist_free_text;
	    lxtext_data->lxtype.lead = _libx1f4i0_lxlist_lead_text;
	    lxtext_data->lxtype.move = NULL;
	    lxtext_data->lxtype.push = _libx1f4i0_lxlist_push_text;
	    lxtext_data->lxtype.slip = _libx1f4i0_lxlist_slip_text;
	}
    }

    *linetext = linetext_data;

    return 0;
}


static int
line_text(struct lxlist_type *lxlist_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxlist_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & AUTOLINK_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxlist_data, bits, screen_data, linetext_data, args,
	     sizeof(auto_line) / sizeof(struct line_type), auto_line);
	linetext_data += sizeof(auto_line) / sizeof(struct line_type);
    }
    if (bits & CASTTYPE_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxlist_data, bits, screen_data, linetext_data, args,
	     sizeof(fail_line) / sizeof(struct line_type), fail_line);
	linetext_data += sizeof(fail_line) / sizeof(struct line_type);
    }
    if (bits & RESETNEW_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxlist_data, bits, screen_data, linetext_data, args,
	     sizeof(call_line) / sizeof(struct line_type), call_line);
	linetext_data += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxlist_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_list(struct lxlist_type *lxlist_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_class, args_count, line_class, line_count, main_class,
	main_count, miss;
    void *data;

    args_count = 0;
    line_count = 1;
    main_count = 0;

    pick_miss(&args_class, &line_class, &main_class, bits, screen_data);

    miss = screen_data->link_t.miss;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & AUTOLINK_LINK) {
	args_count += auto_line_count;
	line_count += sizeof(auto_line) / sizeof(struct line_type);
    }
    if (bits & CASTTYPE_LINK) {
	args_count += fail_line_count;
	line_count += sizeof(fail_line) / sizeof(struct line_type);
    }
    if (bits & RESETNEW_SLIP) {
	args_count += call_line_count;
	line_count += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }

    status = lxlist_data->link_w.link
	(lxlist_data->link_w.data, &data,
	 sizeof(struct lxtext_type) * (1 + miss) + fm_size(away)
	 + (args_class + args_count) * sizeof(int)
	 + (line_class + line_count) * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *)
	 + main_class + main_count);
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side, *tile, *text;

	tile = (struct x1f4_linetext_type *) data + line_class;
	dana = (struct x1f4_linetext_type *) tile + line_count;
	text = (struct lxmiss_type *) dana + 1;
	side = (struct lxtext_type *) text + miss + 1;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;
	dana = (int *) args + args_class + args_count;

	lxlist_data->link_f.data = data;
	lxlist_data->link_f.side = side;
	lxlist_data->link_f.text = text;

	((struct lxmiss_type *) text - 1)->data.miss = miss;

	line_data(lxlist_data, bits, screen_data, data, text, &args, &dana);
	line_text(lxlist_data, bits, screen_data, tile, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_list(lxlist_data, bits, screen_data);
    }

    return status;
}


static int
pick_miss(unsigned *args, unsigned *line, unsigned *pick, unsigned bits,
	  const struct screen_type *screen_data)
{
    const struct lxtype_type *lxtype_data;
    unsigned args_count = 0, line_count = 0, i, main_count = 0;

    lxtype_data = screen_data->link_t.data;
    lxtype_data--;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	unsigned deck, flags;

	lxtype_data++;

	flags = lxtype_data->flags;

	if (flags & X1f4_LX_TYPE_EXCEPT) {
	    continue;
	}

	deck = lxtype_data->size + 1;

	if (1) {
	    args_count += fast_line_count;
	    line_count += fast_line_shift;
	    main_count += deck * fast_line_shift + fast_line_class;
	}
	if (bits & AUTOLINK_LINK) {
	    args_count += cast_line_count;
	    line_count += cast_line_shift;
	    main_count += deck * cast_line_shift + cast_line_class;
	}

	if (flags & FLAT_REFLEX) {
	} else {
	    args_count += l_d_type_post;
	    args_count += l_e_type_post;
	    args_count += l_v_type_post;
	}
	if (flags & LINK_ACCESS) {
	    args_count += long_line_count;
	    line_count += long_line_shift;
	    main_count += deck * long_line_shift + long_line_class;
	}
	if (flags & POST_ACCESS && bits & AUTOLINK_LINK) {
	    args_count += spin_line_count;
	    line_count += spin_line_shift;
	    main_count += deck * spin_line_shift + spin_line_class;
	}
	if (bits & AUTOLINK_LINK
	    || (!lxtype_data->lead && lxtype_data->code != X1f4_E4_TEXT)) {
	    args_count += past_line_count;
	    line_count += past_line_shift;
	    main_count += deck * past_line_shift + past_line_class;
	}
    }

    *args = args_count;
    *line = line_count;
    *pick = main_count;

    return 0;
}


static void
line_amix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxlist_a_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_a_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_a_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_a_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_a_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_a_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_aset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_asub(u_case_args_____1)
{
    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_bmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_bmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    linetext_data->function.type = type;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxlist_b_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_b_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_b_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_b_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_b_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_b_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_bset(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_bsub(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_csub(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_dfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_dmix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxlist_d_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_d_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_d_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_d_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_d_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_d_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_dset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_emap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_emix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxlist_e_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_e_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_e_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_e_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_e_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_e_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_eset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_esub(u_case_args_____1)
{
    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_eway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = X1f4_E4_SLIP;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;
    *line++ = 0;

    *args = line;
}


static void
line_gway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = X1f4_E4_SLIP;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;
    *line++ = 0;

    *args = line;
}


static void
line_hmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxlist_h_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_h_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_h_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_h_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_h_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_h_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_hset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_imap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_imix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxlist_i_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_i_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_i_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_i_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_i_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_i_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_iset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_kfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_lfar(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_lfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_lmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_lset(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_lway(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_mfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_nfix(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;

    linetext_data->function.type = nodetype_data->code;
}


static void
line_nset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_ofix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_pfar(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxlist_p_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_p_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_p_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_p_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_p_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_p_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_pset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_pway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_qmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxlist_q_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_q_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_q_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_q_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_q_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_q_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_qset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_rfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_rmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxlist_r_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_r_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_r_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_r_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_r_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_r_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_rset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_rway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_smap(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_sway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_tfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_tmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_tmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxlist_t_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_t_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_t_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_t_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_t_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_t_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_tset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_uset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_vmix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxlist_v_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_v_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_v_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_v_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_v_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_v_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_wfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_xmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;

    linetext_data->function.type = type;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxlist_x_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_x_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_x_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_x_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_x_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_x_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_zfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_zmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    linetext_data->function.type = type;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxlist_z_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxlist_z_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxlist_z_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxlist_z_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxlist_z_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxlist_z_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


int
x1f4_init_lxlist(void **lxlist, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *list, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &list, sizeof(struct lxlist_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_list(list, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, list);
	    } else {
		_x1f4_e4_free_data(text, list);
	    }
	} else {
	    SRAND_INIT();

	    *lxlist = list;
	}
    }

    return status;
}
