/*
 * lxline.h
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxline_H__
#define __LIBx1f4_lxline_H__

#include <dt.h>
#include <nl.h>
#include <nt.h>
#include <trans.h>

/*
 * common data type flag definitions
 */
#define X1f4_LX_LINK_ACCESS		(1L << 1)
#define X1f4_LX_POST_ACCESS		(1L << 2)

/*
 * error definitions
 */
#define X1f4_LXLINE_DECK_ERROR		-1
#define X1f4_LXLINE_FREE_ERROR		-2
#define X1f4_LXLINE_LINK_ERROR		-3
#define X1f4_LXLINE_MODE_ERROR		-4

/*
 * generation flag definitions
 */
#define X1f4_LXLINE_AUTOLINK		(1L << 0)
#define X1f4_LXLINE_CASTTYPE		(1L << 1)
#define X1f4_LXLINE_CODELINK		(1L << 2)
#define X1f4_LXLINE_EELOOKUP		(1L << 3)
#define X1f4_LXLINE_EVERLINK		(1L << 4)
#define X1f4_LXLINE_MISSBAIL		(1L << 5)
#define X1f4_LXLINE_RESETNEW		(1L << 6)
#define X1f4_LXLINE_RESOURCE		(1L << 7)
#define X1f4_LXLINE_TEXTFLAT		(1L << 8)
#define X1f4_LXLINE_TRANSFER		(1L << 9)

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

typedef struct x1f4_dxline_type {
    unsigned size;
    void *line;
} x1f4_dxline_type;

typedef struct x1f4_lxline_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	struct x1f4_eelookup_type *eelookup_data;
    } eelookup_set;
    struct {
	int type;
    } linetype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct {
	int (*call) (void *, struct x1f4_nodelink_type *),
	    (*fine) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *),
	    (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);
	void *text;
    } missbail_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	unsigned miss;
	const struct x1f4_nodetype_type *nodetype_data;
    } datatype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **),
	    (*slip) (void *, void *, void *, int (*) (void *));
	void *data;
    } autolink_set;
    struct x1f4_trans_type codelink_set;
} x1f4_lxline_type;

extern int x1f4_cfix_lxline(void *, unsigned, void *);
extern int x1f4_copy_lxline
    (void *, void *, void **, const void *,
     const struct x1f4_nodelink_type *);
extern int x1f4_dset_lxline(void *, const struct x1f4_datatype_type **);
extern int x1f4_fare_lxline
    (void *, void *, void **, const void *, const struct x1f4_nodelink_type *);
extern int x1f4_fini_lxline(void **);
extern int x1f4_flat_lxline(void *, void **);
extern int x1f4_free_lxline
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_fset_lxline(void *, const struct x1f4_linetext_type **);
extern int x1f4_init_lxline
    (void **, unsigned, const struct x1f4_lxline_type *);
extern int x1f4_move_lxline
    (void *, void *, const struct x1f4_nodelink_type *,
     const struct x1f4_nodelink_type *);
extern int x1f4_node_lxline
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_post_lxline
    (void *, void **, const struct x1f4_nodelink_type *);
extern int x1f4_push_lxline
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_text_lxline(void *, unsigned, void *);

#endif				/* __LIBx1f4_lxline_H__ */
