/*
 * lxline-v.t.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxcall.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

#define lxtext(delete)			((struct lxtext_type *) (delete))

int
_libx1f4i0_lxline_t_class_v(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data;
    void *data;

    lxtext_data = context;

    lxline_data = lxtext_data->text;

    dxline_data = I_LINE(input[0]);

    status = _libx1f4i0_ever_sfnote(dxline_data->line, &data);
    if (status) {
	status = _libx1f4i0_lxline_stat_line(lxline_data, status);
    } else {
	struct lxtext_type *lxtext_data;
	unsigned type;

	lxtext_data = context;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];
	if (type != lxtext_data->lxtype.code) {
	    status = _libx1f4i0_lxline_stat_ends
		(lxline_data, 1, type, lxtext_data->lxtype.code);
	} else {
	    status = _libx1f4i0_lxcall_pick_node
		(&lxline_data->link_v, &lxline_data->link_e,
		 &lxtext_data->lxtype, I_USER(byte(data) + 8), output);
	}
    }

    return status;
}
