/*
 * lxline-t.f.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <fd.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_f_class_t(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data, *lxtext_link;
    unsigned link;
    void *data, *side;

    dxline_data = I_LINE(input[0]);

    lxtext_data = context;

    lxline_data = lxtext_data->text;

    fail = I_TEXT(input[1]);

    if (0) {
    } else {
	do {
	    lxtext_link = lxline_data->link_f.text;

	    status = lxtext_data->lxtype.copy
		(lxtext_data->lxtype.context, NULL, &side,
		 I_USER(input[2]), lock_excase(dxline_data));
	    if (status) {
		if (1) {
		    break;
		}
	    }

	    status = _libx1f4i0_post_sfnote
		(dxline_data->line, fail, sizeof(struct fxdata_type) + 8,
		 &data);
	    if (status) {
		if (status ^ X1f4_SFNOTE_EVER_MATCH) {
		    status = _libx1f4i0_lxline_stat_line(lxline_data, status);

		    lxtext_data->lxtype.free
			(lxtext_data->lxtype.context, side,
			 NULL, lock_excase(dxline_data));

		    break;
		} else {
		    void *slip;

		    status = 0;

		    slip = data;

		    link = byte(slip)[4] << 030 | byte(slip)[5] << 020
			| byte(slip)[6] << 010 | byte(slip)[7];

		    if (~link) {
			int (*free) (void *, void *, struct excase_type **,
				     const struct excase_type *);
			struct lxtext_type *lxtext_slip;

			lxtext_slip = lxtext_link + link;

			free = lxtext_slip->lxtype.free;
			if (free) {
			    status = free
				(lxtext_slip->lxtype.context,
				 I_USER(byte(slip) + 8), NULL,
				 lock_excase(dxline_data));
			}
		    }
		}
	    } else {
		dxline_data->size++;
	    }

	    {
#define type				X1f4_E4_TEXT

		unsigned link;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = lxtext_data - lxtext_link;

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;

		l_TEXT(side, byte(data) + 8);

#undef type
	    }
	} while (0);
    }

    return status;
}
