/*
 * lxline-s.p.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <retain.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_p_sequent(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    void *data, *line;

    dxline_data = I_LINE(input[0]);

    lxline_data = context;

    line = dxline_data->line;

    status = _libx1f4i0_ever_sfnote(line, &data);
    if (status) {
	status = _libx1f4i0_lxline_stat_line(context, status);
    } else {
	status = _libx1f4i0_lxline_post_data(lxline_data, output, data);
	if (status) {
	} else {
#if __RETAIN_OBJECT_DATA__
# error not considered
#else
	    unsigned link;

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];

	    if (~link) {
		struct lxtext_type *lxtext_data;

		lxtext_data = lxline_data->link_f.text;
		lxtext_data += link;
		if (lxtext_data->lxtype.lead) {
		    status = lxtext_data->lxtype.free
			(lxtext_data->lxtype.context, I_USER(byte(data) + 8),
			 NULL, lock_excase(dxline_data));
		} else {
		}
	    }

	    if (status) {
	    } else {
		status = _libx1f4i0_slip_sfnote(line);
		if (status) {
		    byte(data)[4] = ~0 >> 030;
		    byte(data)[5] = ~0 >> 020;
		    byte(data)[6] = ~0 >> 010;
		    byte(data)[7] = ~0 >> 000;

		    status = _libx1f4i0_lxline_stat_line(lxline_data, status);
		} else {
		    dxline_data->size--;
		}
	    }
#endif				/* __RETAIN_OBJECT_DATA__ */
	}
    }

    return status;
}
