/*
 * lxline-m.x.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_x_class_m(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data;
    void *data;

    lxtext_data = context;

    lxline_data = lxtext_data->text;

    dxline_data = I_LINE(input[0]);

    fail = I_TEXT(input[1]);

    status = _libx1f4i0_find_sfnote(dxline_data->line, fail, &data);
    if (status) {
	unsigned type;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];
	if (type != X1f4_E4_MODE) {
	    status = _libx1f4i0_lxline_stat_type
		(lxline_data, fail, type, lxtext_data->lxtype.code);
	} else {
	    X1f4_E4_C_MODE fast;

	    fast = I_MODE(byte(data) + 8);

	    status = _libx1f4i0_pass_sfnote(dxline_data->line, fail);
	    if (status) {
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);
	    } else {
		dxline_data->size--;

		if (0) {
		} else {
		    l_MODE(fast, output);
		}
	    }
	}
    } else {
	status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
    }

    return status;
}
