/*
 * lxline-m.l.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <fd.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_a_break_m(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    struct lxtext_type *lxtext_data, *lxtext_link;
    void *data;

    dxline_data = I_LINE(input[0]);

    lxtext_data = context;

    lxline_data = lxtext_data->text;

    do {
	X1f4_E4_C_MODE mode;

	mode = I_MODE(input[2]);

	lxtext_link = lxline_data->link_f.text;

	status = _libx1f4i0_post_sfnote
	    (dxline_data->line, I_TEXT(input[1]),
	     sizeof(struct fxdata_type) + 8, &data);
	if (status) {
	    if (status ^ X1f4_SFNOTE_EVER_MATCH) {
		status = _libx1f4i0_lxline_stat_line(lxline_data, status);

		break;
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != X1f4_E4_MODE) {
		    status = _libx1f4i0_lxline_stat_type
			(lxtext_data->text, I_TEXT(input[1]), type,
			 lxtext_data->lxtype.code);
		    if (1) {
			break;
		    }
		}

		status = 0;

		mode += I_MODE(byte(data) + 8);
	    }
	} else {
	    dxline_data->size++;
	}

	{
#define type				X1f4_E4_MODE

	    unsigned link;

	    byte(data)[0] = type >> 030;
	    byte(data)[1] = type >> 020;
	    byte(data)[2] = type >> 010;
	    byte(data)[3] = type >> 000;

	    link = lxtext_data - lxtext_link;

	    byte(data)[4] = link >> 030;
	    byte(data)[5] = link >> 020;
	    byte(data)[6] = link >> 010;
	    byte(data)[7] = link >> 000;

	    l_MODE(mode, output);

	    l_MODE(mode, byte(data) + 8);

#undef type
	}
    } while (0);

    return status;
}
