/*
 * lxline-l.l.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxcall.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxline_l_logique(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;

    dxline_data = I_LINE(input[0]);

    if (0) {
    } else {
	const char *lift;
	unsigned size;
	void *data;

	status = _libx1f4i0_hike_sfnote
	    (dxline_data->line, &data, &lift, &size);
	if (status) {
	    status = _libx1f4i0_lxline_stat_line(context, status);
	} else {
	    status = _libx1f4i0_lxcall_part_text
		(&((struct lxline_type *) context)->link_v,
		 &((struct lxline_type *) context)->link_e, lift, size,
		 output);
	}
    }

    return status;
}
