/*
 * lxline-e.n.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <tcvset.h>

#define lxline(line) \
    ((struct lxline_type *) (line))

int
_libx1f4i0_lxline_fine_line(void *subtext, void *dxline)
{
    int status;
    struct dxline_type *dxline_data;

    dxline_data = dxline;
    if (0) {
    } else {
	if (0) {
	} else {
	    int (*call) (void *, struct x1f4_nodelink_type *), excess;

	    status = _libx1f4i0_fini_tcvset
		(&lock_exline(dxline_data)->pset,
		 &lock_exline(dxline_data)->text,
		 (void *) &((struct lxline_type *) subtext)->link_m);
	    if (status) {
		status = _libx1f4i0_lxline_stat_free(subtext);
	    }

	    call = lxline(subtext)->link_r.call;
	    if (call) {
		call(lxline(subtext)->link_r.text, lock_excase(dxline));
	    }

	    excess = _libx1f4i0_flat_sfnote(dxline_data->line);
	    if (excess) {
		excess = _libx1f4i0_lxline_stat_line(subtext, excess);
		if (status) {
		} else {
		    status = excess;
		}
	    }

	    excess = ((struct lxline_type *) subtext)->link_m.free
		(((struct lxline_type *) subtext)->link_m.data,
		 lock_cxline(dxline_data));
	    if (excess) {
		excess = _libx1f4i0_lxline_stat_free(subtext);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}
