/*
 * lxline-e.i.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <exerrors.h>
#include <lxlead.h>
#include <lxline-types.h>
#include <nl.h>
#include <tcvset.h>

#define lxline(line) \
    ((struct lxline_type *) (line))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_move_lxline(void *subtext, void *dxline,
		 const struct x1f4_nodelink_type *excase_miss,
		 const struct x1f4_nodelink_type *excase_push)
{
    int status;

    status = tccase(lock_exline(dxline)->text)->mode
	(&lock_exline(dxline)->pset, excase_miss, excase_push);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	int (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);

	miss = lxline(subtext)->link_r.miss;
	if (miss) {
	    status = miss
		(lxline(subtext)->link_r.text, NULL, lock_excase(dxline));
	} else {
	    status = x1f4_mind_lxlead(NULL, dxline);
	}
    }

    return status;
}
