/*
 * lxline-e.c.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <exerrors.h>
#include <lxlead.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <tcvset.h>

#define lxline(line) \
    ((struct lxline_type *) (line))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_free_lxline(void *subtext, void *dxline, struct excase_type **excase,
		 const struct excase_type *excase_data)
{
    int status;
    unsigned call;

    call = lock_exline(dxline)->call;

    /*
     * FEATURES
     *
     * some code will work even without this test, but some will not.  among
     * the one that will not is _long_line/_near_line (some reasons recorded
     * there).
     */
    if (call) {
	call--;
	if (call) {
	    /*
	     * _excase_data_ may actually be not present in the _pset_ pointer
	     * set (as a result of a failed operation) and if that's the case
	     * processing should be allowed (i.e. a _miss_ call for a
	     * nonexistent _excase_data_ pointer should be successful (as it
	     * currently is))
	     */
	    status = tccase(lock_exline(dxline)->text)->miss
		(&lock_exline(dxline)->pset, &lock_exline(dxline)->text,
		 excase_data, (void *) &lxline(subtext)->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;
	    } else {
		int (*miss) (void *, struct x1f4_nodelink_type **,
			     struct x1f4_nodelink_type *);

		lock_exline(dxline)->call = call;

		miss = lxline(subtext)->link_r.miss;
		if (miss) {
		    status = miss
			(lxline(subtext)->link_r.text, excase,
			 lock_excase(dxline));
		} else {
		    status = x1f4_mind_lxlead(excase, dxline);
		}
	    }
	} else {
	    status = _libx1f4i0_lxline_heap_line(subtext, excase, dxline);
	}
    } else {
	status = 0;
    }

    return status;
}
