/*
 * lxline-e.9.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <stddef.h>

#include <exerrors.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <tcvset.h>

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_post_lxline(void *subtext, void **address,
		 const struct excase_type *excase_data)
{
    int status;
    struct lxline_type *lxline_data;
    unsigned call;
    void *dxline;

    lxline_data = subtext;

    _libx1f4i0_call_sfnote(&call);

    status = lxline_data->link_m.link
	(lxline_data->link_m.data, &dxline,
	 __struct_dxline_type_alloc_size__ + call);
    if (status) {
	status = _libx1f4i0_lxline_stat_link(lxline_data);
    } else {
	dxline = pick_dxline(dxline);

	status = _libx1f4i0_lxline_fast_line(subtext, dxline);
	if (status) {
	    lxline_data->link_m.free
		(lxline_data->link_m.data, lock_cxline(dxline));
	} else {
	    void *pset;
	    const void *text;

	    ((struct dxline_type *) dxline)->size = 0;

	    lock_excase(dxline)->nodetype_data = lxline_data->link_n.node;

	    lock_excase(dxline)->slip = NULL;

	    lock_exline(dxline)->call = 1;

	    _libx1f4i0_init_tcvset(&pset, &text);

	    status = tccase(text)->push
		(&pset, &text, excase_data, (void *) &lxline_data->link_m);
	    if (status) {
		status = X1f4_EX_CRITICAL;

		_libx1f4i0_lxline_side_line(subtext, dxline);
	    } else {
		*address = dxline;

		lock_exline(dxline)->pset = pset;
		lock_exline(dxline)->text = text;
	    }
	}
    }

    return status;
}
