/*
 * lxline-e.4.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-inter.h>
#include <lxline-types.h>
#include <trans.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxline_slip_text(void *subtext, void **call)
{
    int status;
    void *text;

    text = *call;
    if (text == x1f4_c1_empty_string) {
	status = 0;
    } else {
	struct lxline_type *lxline_data;

	lxline_data = subtext;

	status = lxline_data->link_m.free(lxline_data->link_m.data, text);
	if (status) {
	    status = _libx1f4i0_lxline_stat_free(lxline_data);
	}
    }

    return status;
}
