/*
 * lxline-d.k.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxcall.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_k_derived(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_TEXT fail;
	X1f4_E4_C_USER slip;
	struct dxline_type *dxline_data;
	struct lxline_type *lxline_data;
	struct lxtext_type *lxtext_data;

	lxtext_data = context;

	lxline_data = lxtext_data->text;

	dxline_data = I_LINE(input[1]);

	fail = I_TEXT(input[2]);

	if (1) {
	    void *data;

	    status = _libx1f4i0_find_sfnote(dxline_data->line, fail, &data);
	    if (status) {
		unsigned type;

		status = 0;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != lxtext_data->lxtype.code) {
		    l_MODE(0, output);
		    if (1) {
			break;
		    }
		} else {
		    slip = I_USER(byte(data) + 8);
		}
	    } else {
		status = _libx1f4i0_lxline_n_logique
		    (context, &slip, input + 1);
		if (status) {
		    break;
		}
	    }
	}

	status = _libx1f4i0_lxcall_land_node
	    (&lxline_data->link_v, &lxline_data->link_e, &lxtext_data->lxtype,
	     slip, input[0]);
	if (status) {
	} else {
	    l_MODE(1, output);
	}
    } while (0);

    return status;
}
