/*
 * lxline-d.g.1.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <copy.h>
#include <e4.h>
#include <fd.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_g1derived(void *context, void *output, void **input)
{
    X1f4_E4_C_TEXT fail;
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    void *data, **side;

    side = context;

    lxline_data = *side;

    dxline_data = I_LINE(input[1]);

    fail = I_TEXT(input[2]);

    status = _libx1f4i0_find_sfnote(dxline_data->line, fail, &data);
    if (status) {
	unsigned call, type;

	type = byte(data)[0] << 030 | byte(data)[1] << 020
	    | byte(data)[2] << 010 | byte(data)[3];
	call = *((struct x1f4_function_type *) *(side + 1))->args;
	if (type != call) {
	    status = _libx1f4i0_lxline_stat_type
		(lxline_data, fail, type, call);
	} else {
	    unsigned link;

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];

	    status = 0;

	    do {
		struct fxdata_type fxdata;

		fxdata = *(struct fxdata_type *) (byte(data) + 8);

		if (~link) {
		    struct lxtext_type *lxtext_data;

		    lxtext_data = lxline_data->link_f.text;
		    lxtext_data += link;
		    if (lxtext_data->lxtype.lead) {
			status = lxtext_data->lxtype.lead
			    (lxtext_data->lxtype.context, (void *) &fxdata);
			if (status) {
			    break;
			}
		    }
		    if (lxtext_data->lxtype.slip) {
			status = lxtext_data->lxtype.slip
			    (lxtext_data->lxtype.context, *input);
			if (status) {
			    break;
			}
		    }
		}

		copy_miss(*input, type, &fxdata);
	    } while (0);
	}
    } else {
	status = _libx1f4i0_lxline_stat_miss(lxline_data, fail);
    }

    return status;
}
