/*
 * lxline-d.b.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <l_note.h>
#include <lxcast.h>
#include <lxline-close.h>
#include <lxline-inter.h>
#include <lxline-types.h>
#include <nt.h>

#define I_LINE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxline_b_derived(void *context, void *output, void **input)
{
    int status;
    struct dxline_type *dxline_data;
    struct lxline_type *lxline_data;
    void *data;

    dxline_data = I_LINE(input[0]);

    lxline_data = context;

    status = _libx1f4i0_find_sfnote
	(dxline_data->line, I_TEXT(input[1]), &data);
    if (status) {
	int type;
	struct lxtext_type *lxtext_data, *lxtext_link;
	struct x1f4_dxcast_type *dxcast_data;
	unsigned miss;

	dxcast_data = I_USER(input[2]);

	type = dxcast_data->type;

	lxtext_link = lxline_data->link_f.text;

	lxtext_data = lxtext_link;

	close_frame(miss, lxtext_data);

	do {
	    int (*copy) (void *, void *, void **, const void *,
			 const struct x1f4_nodelink_type *),
	        (*node) (void *, void **, void *,
			 const struct x1f4_nodelink_type *);
	    void *side;

	    if (miss) {
		if (lxtext_data->lxtype.flags & X1f4_LX_LINK_ACCESS) {
		    node = lxtext_data->lxtype.node;
		    copy = NULL;
		} else {
		    node = NULL;
		    copy = lxtext_data->lxtype.copy;
		    if (copy) {
			status = copy
			    (lxtext_data->lxtype.context, NULL, &side,
			     I_USER(&dxcast_data->data),
			     lock_excase(dxline_data));
			if (status) {
			    break;
			}
		    } else {
			status = 0;
		    }
		}
	    } else {
		status = 0;
		copy = NULL;
		node = NULL;
	    }

	    if (1) {
		unsigned link;
		void *slip;

		slip = data;

		link = byte(slip)[4] << 030 | byte(slip)[5] << 020
		    | byte(slip)[6] << 010 | byte(slip)[7];

		if (~link) {
		    int (*free) (void *, void *, struct excase_type **,
				 const struct excase_type *);
		    struct lxtext_type *lxtext_slip;

		    lxtext_slip = lxtext_link + link;

		    free = lxtext_slip->lxtype.free;
		    if (free) {
			status = free
			    (lxtext_slip->lxtype.context,
			     I_USER(byte(slip) + 8), NULL,
			     lock_excase(dxline_data));
			if (status) {
			    if (copy) {
				lxtext_data->lxtype.free
				    (lxtext_data->lxtype.context, side,
				     NULL, lock_excase(dxline_data));
			    }

			    break;
			}
		    }
		}
	    }

	    {
		unsigned link;

		byte(data)[0] = type >> 030;
		byte(data)[1] = type >> 020;
		byte(data)[2] = type >> 010;
		byte(data)[3] = type >> 000;

		link = miss ? lxtext_data - lxtext_link : ~0;

		if (node) {
		    status = node
			(lxtext_data->lxtype.context,
			 (void *) (byte(data) + 8), I_USER(&dxcast_data->data),
			 lock_excase(dxline_data));
		    if (status) {
			link = ~0;
		    }
		} else {
		    if (copy) {
			l_USER(side, byte(data) + 8);
		    } else {
			copy_miss(byte(data) + 8, type, &dxcast_data->data);
		    }
		}

		byte(data)[4] = link >> 030;
		byte(data)[5] = link >> 020;
		byte(data)[6] = link >> 010;
		byte(data)[7] = link >> 000;
	    }
	} while (0);
    } else {
	status = _libx1f4i0_lxline_stat_miss(lxline_data, I_TEXT(input[1]));
    }

    return status;
}
