/*
 * lxline-c.r.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <lxline-inter.h>
#include <lxline-types.h>

int
_libx1f4i0_lxline_r_centric(void *context, void *data, void **text)
{
    int status;

    do {
	const int *args;
	struct lxline_type *lxline_data;
	struct x1f4_function_type *function_data;
	unsigned count;
	void *near;

	lxline_data = context;

	function_data = data;

	count = function_data->count;

	if (count & 1) {
	    status = _libx1f4i0_lxline_stat_odds(lxline_data);
	    if (1) {
		break;
	    }
	}

	args = function_data->args;
	for (; count; count -= 2) {
	    if (*args != X1f4_E4_TEXT) {
		break;
	    } else {
		args += 2;
	    }
	}
	if (count) {
	    status = _libx1f4i0_lxline_stat_lock
		(lxline_data, function_data->count - count);
	    if (1) {
		break;
	    }
	}

        function_data->function = _libx1f4i0_lxline_r1centric;

	status = lxline_data->link_v.link
	    (lxline_data->link_v.data, &near, sizeof(void *) << 1);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	} else {
	    void **side;

	    side = near;

	    *text = side;

	    *side = lxline_data;
	    side[1] = function_data;
	}
    } while (0);

    return status;
}
