/*
 * lxline-c.r.1.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define l_LINE(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

static int rule_line(struct lxline_type *, void *, struct x1f4_function_type *,
		     void **);
static int slip_line(void *news);

static int
rule_line(struct lxline_type *lxline_data, void *line,
	  struct x1f4_function_type *function_data, void **input)
{
    int status = 0;
    unsigned count;

    count = function_data->count;
    if (count) {
	const int *args;
	struct x1f4_dxcast_type dxcast;
	void *miss, *slip[3];

	args = function_data->args;

	slip[0] = &line;
	slip[2] = &miss;

	miss = &dxcast;

	args++;

	for (; count; count -= 2) {
	    dxcast.type = *args;
	    args += 2;
	    slip[1] = *input++;
	    if (dxcast.type == X1f4_E4_CASE) {
		slip[2] = *input++;
		status = _libx1f4i0_lxline_p_forward(lxline_data, NULL, slip);
		slip[2] = &miss;
	    } else {
		copy_miss(&dxcast.data, dxcast.type, *input++);
		status = _libx1f4i0_lxline_p_forward(lxline_data, NULL, slip);
	    }
	    if (status) {
		break;
	    }
	}
    }

    return status;
}


static int
slip_line(void *news)
{
    int status;
    void *line, **side;

    side = news;
    line = side[1];
    if (line) {
	status = _libx1f4i0_lxline_side_line(*side, line);
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxline_r1centric(void *context, void *output, void **input)
{
    int status;
    struct lxline_type *lxline_data;
    void **mind, *news, **side;

    side = context;

    lxline_data = *side;

    status = lxline_data->link_v.pick
	(lxline_data->link_v.data, &mind, slip_line, sizeof(void *) << 1,
	 &news);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	void *line, **seek;

	*mind = news;

	seek = news;

	*seek++ = lxline_data;

	status = _libx1f4i0_lxline_line_line(lxline_data, &line);
	if (status) {
	    *seek = NULL;
	} else {
	    *seek = line;

	    l_LINE(line, output);

	    status = rule_line(lxline_data, line, *++side, input);
	}
    }

    return status;
}
