/*
 * lxline-c.f.1.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <copy.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>
#include <lxline-inter.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

int
_libx1f4i0_lxline_f1centric(void *context, void *output, void **input)
{
    int status;
    struct lxline_type *lxline_data;
    struct x1f4_function_type *function_data;
    unsigned count;
    void **side;

    side = context;

    lxline_data = *side;

    function_data = *++side;

    status = 0;

    count = function_data->count - 1;
    if (count) {
	const int *args;
	struct x1f4_dxcast_type dxcast;
	void *miss, *slip[3];

	args = function_data->args;

	slip[0] = *input;
	slip[2] = &miss;

	miss = &dxcast;

	do {
	    slip[1] = *++input;
	    args += 2;
	    dxcast.type = *args;
	    if (dxcast.type == X1f4_E4_CASE) {
		slip[2] = *++input;
		status = _libx1f4i0_lxline_p_forward(lxline_data, NULL, slip);
		slip[2] = &miss;
	    } else {
		copy_miss(&dxcast.data, dxcast.type, *++input);
		status = _libx1f4i0_lxline_p_forward(lxline_data, NULL, slip);
	    }
	    if (status) {
		break;
	    }
	} while (count -= 2);
    }

    return status;
}
