/*
 * lxline-a.x.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <exerrors.h>
#include <lxcall.h>
#include <lxline-types.h>
#include <tcvset.h>

#define lxline(list) \
    ((struct lxline_type *) (list))

#define lxline(list) \
    ((struct lxline_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_push_lxline(void *lxline, void **copy, void *line,
		 const struct excase_type *excase_data)
{
    int status;

    status = tccase(lock_exline(line)->text)->miss
	(&lock_exline(line)->pset, &lock_exline(line)->text, excase_data,
	 (void *) &((struct lxline_type *) lxline)->link_m);
    if (status) {
	status = X1f4_EX_CRITICAL;
    } else {
	status = _libx1f4i0_lxcall_near_node
	    (&lxline(lxline)->link_v, &lxline(lxline)->link_e,
	     lxline(lxline)->link_t.datatype, *copy);
	if (status) {
	} else {
	    *copy = (void *) line;
	}
    }

    return status;
}
