/*
 * lxline-a.q.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define way_red(context)		((void **) (context))

static int lime_line(void *, void *);

static int
lime_line(void *context, void *data)
{
    int status;
    unsigned link;

    link = byte(data)[4] << 030 | byte(data)[5] << 020 | byte(data)[6] << 010
	| byte(data)[7];
    if (~link) {
	int (*move) (void *, void *, const struct excase_type *,
		     const struct excase_type *);
	struct lxtext_type *lxtext_data;

	lxtext_data = (struct lxtext_type *)
	    ((struct lxline_type *) way_red(context)[1])->link_f.text + link;

	move = lxtext_data->lxtype.move;
	if (move) {
	    status = move
		(lxtext_data->lxtype.context,
		 I_USER(byte(data) + 8), way_red(context)[2],
		 way_red(context)[3]);
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxline_down_line(void *subtext, void *excase, void *dxline)
{
    int status;
    void *way_red[4];

    way_red[1] = subtext;
    way_red[2] = excase;
    way_red[3] = lock_excase(dxline);

    status = _libx1f4i0_lime_sfnote
	(((const struct dxline_type *) dxline)->line, way_red, lime_line);

    return status;
}
