/*
 * lxline-a.l.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <l_note.h>
#include <lxcall.h>
#include <lxlead.h>
#include <lxline-defs.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define dxline(line) \
    ((struct dxline_type *) (line))
#define lxline(line) \
    ((struct lxline_type *) (line))

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

typedef struct text_type {
    int delete;
    struct excase_type *excase_data, *excase_lock;
    void *lxline;
} text_type;

static int flat_node(void *, void *);

static int
flat_node(void *text, void *node)
{
    struct lxline_type *lxline_data;
    unsigned link;
    void *data;

    lxline_data = ((struct text_type *) text)->lxline;

    data = (void *) node;

    link = byte(data)[4] << 030 | byte(data)[5] << 020 | byte(data)[6] << 010
	| byte(data)[7];
    if (~link) {
	int (*free) (void *, void *, struct excase_type **,
		     const struct excase_type *);
	struct lxtext_type *lxtext_link;

	lxtext_link = ((struct lxtext_type *) lxline_data->link_f.text) + link;

	if (lxtext_link->lxtype.flags & X1f4_LX_PICK_ACCESS) {
	    free = lxtext_link->lxtype.pick;
	} else {
	    free = lxtext_link->lxtype.free;
	}
	if (free) {
	    int delete;

	    delete = free
		(lxtext_link->lxtype.context, I_USER(byte(data) + 8),
		 &((struct text_type *) text)->excase_data,
		 ((struct text_type *) text)->excase_lock);
	    if (delete) {
		if (((struct text_type *) text)->delete) {
		} else {
		    ((struct text_type *) text)->delete = delete;
		}
	    }
	}
    }

    return 0;
}


int
_libx1f4i0_lxline_null_line(void *lxline,
			    struct excase_type **excase, void *dxline)
{
    int status = 0;
    unsigned size;

    size = dxline(dxline)->size;
    if (size) {
	int excess;
	struct excase_type *excase_data;
	void *line;

	if (excase) {
	    excase_data = *excase;
	} else {
	    excase_data = NULL;
	}

	line = dxline(dxline)->line;

	if (size) {
	    struct text_type text;

	    text.delete = 0;
	    text.excase_data = excase_data;
	    text.excase_lock = lock_excase(dxline);
	    text.lxline = lxline;

	    _libx1f4i0_lime_sfnote(line, &text, flat_node);

	    excase_data = text.excase_data;

	    status = text.delete;

	    dxline(dxline)->size = 0;
	}

	if (1) {
	    excess = _libx1f4i0_high_sfnote(line);
	    if (excess) {
		excess = _libx1f4i0_lxline_stat_line(lxline, excess);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}

	if (excase) {
	    *excase = excase_data;
	} else {
	    if (excase_data) {
		excess = x1f4_fail_lxlead(excase_data);
		if (excess) {
		    status = _libx1f4i0_lxcall_land_slip(excess, status);
		}
	    }
	}
    }

    return status;
}
