/*
 * lxline-a.e.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <er.h>
#include <exerrors.h>
#include <l_note.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define lxline(lxline) \
    ((struct lxline_type *) (lxline))


int
_libx1f4i0_lxline_stat_ends(void *lxline, int tail, unsigned found,
			    unsigned expected)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("mismatched type (", 17);
    PUSH_TRAP(found, lxline(lxline));
    PUSH_DATA(" found, ", 8);
    PUSH_TRAP(expected, lxline(lxline));
    PUSH_DATA(" expected) for ", 15);
    if (tail) {
	PUSH_DATA("last", 4);
    } else {
	PUSH_DATA("first", 5);
    }
    PUSH_DATA(" key", 4);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_even(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("even number of parameters", 25);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_ever(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("key exists", 10);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_flat(void *lxline, const char *text)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("numeric type expected for the `", 31);
    PUSH_TEXT(text);
    PUSH_DATA("' key", 5);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_free(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxline_stat_lead(void *lxline, unsigned type)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("will not box non referable, non intrinsic object of type ", 57);
    PUSH_TRAP(type, lxline(lxline));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_link(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxline_stat_line(void *lxline, int error)
{
    int status;

    if (error == X1f4_SFNOTE_DECK_ERROR) {
	status = _libx1f4i0_lxline_stat_null(lxline);
    } else {
	if (error == X1f4_SFNOTE_EVER_MATCH) {
	    status = _libx1f4i0_lxline_stat_ever(lxline);
	} else {
	    if (error == X1f4_SFNOTE_FREE_ERROR) {
		status = _libx1f4i0_lxline_stat_free(lxline);
	    } else {
		if (error == X1f4_SFNOTE_LINK_ERROR) {
		    status = _libx1f4i0_lxline_stat_link(lxline);
		} else {
		    if (error == X1f4_SFNOTE_MODE_ERROR) {
			status = _libx1f4i0_lxline_stat_mode(lxline);
		    } else {
			status = X1f4_EX_CRITICAL;
		    }
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxline_stat_lock(void *lxline, int mode)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("non intrinsic string ", 21);
    PUSH_MODE(mode + 1);
    PUSH_RANK(mode);
    PUSH_DATA(" index argument", 15);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_miss(void *lxline, const char *text)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("no mapping for key `", 20);
    PUSH_TEXT(text);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_mode(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxline_stat_null(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("void record", 11);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_odds(void *lxline)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("odd number of parameters", 24);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_post(void *lxline, const char *text)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("key `", 5);
    PUSH_TEXT(text);
    PUSH_DATA("' exists", 8);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxline_stat_text(void *lxline, int error, const char *text)
{
    int status;

    if (error == X1f4_SFNOTE_EVER_MATCH) {
	status = _libx1f4i0_lxline_stat_post(lxline, text);
    } else {
	if (1) {
	    status = _libx1f4i0_lxline_stat_line(lxline, error);
	}
    }

    return status;
}


int
_libx1f4i0_lxline_stat_type(void *lxline, const char *text, unsigned found,
			    unsigned expected)
{
    LINE_EEER(lxline(lxline)->link_e);

    PUSH_DATA("mismatched type (", 17);
    PUSH_TRAP(found, lxline(lxline));
    PUSH_DATA(" found, ", 8);
    PUSH_TRAP(expected, lxline(lxline));
    PUSH_DATA(" expected) for `", 16);
    PUSH_TEXT(text);
    PUSH_DATA("' key", 5);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
