/*
 * lxline-a.c.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxline-config.h>

#include <stddef.h>

#include <lxlead.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define break_cycles			0

#define lxline(line) \
    ((struct lxline_type *) (line))

int
_libx1f4i0_lxline_side_line(void *subtext, void *dxline)
{
    int status;
    unsigned call;

    call = lock_exline(dxline)->call;
    if (call ^ 1) {
	int (*miss) (void *, struct x1f4_nodelink_type **,
		     struct x1f4_nodelink_type *);

	lock_exline(dxline)->call = call - 1;

	miss = lxline(subtext)->link_r.miss;
	if (miss) {
	    status = miss
		(lxline(subtext)->link_r.text, NULL, lock_excase(dxline));
	} else {
	    status = x1f4_mind_lxlead(NULL, dxline);
	}
    } else {
	int excess;

	lock_exline(dxline)->call = break_cycles;

	status = _libx1f4i0_lxline_null_line(subtext, NULL, dxline);

	excess = _libx1f4i0_lxline_fine_line(subtext, dxline);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
