/*
 * lxline-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 * merge copy_line into fast_line
 */

#include <lxline-config.h>

#include <stddef.h>
#include <string.h>

#include <af.h>
#include <e4-m.0.h>
#include <e4.h>
#include <e4fine.h>
#include <lxcall.h>
#include <lxline-defs.h>
#include <lxline-inter.h>
#include <lxline-types.h>

#define MAKE_SINGLE(a, b)		a

#define may_include(lxtype)		0

#define l_d_type_post			2

#define l_e_type_post			3

#define l_v_type_post			2

#define screen(screen) \
    ((struct screen_type *) (screen))

#define fb_size()			1

#define fm_size(none) \
    sizeof(struct lxmiss_type)

extern const struct x1f4_eelookup_type _x1f4_type_lookup;

static int init_line(struct lxline_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxline_type *, unsigned,
		     const struct screen_type *, void *, void *, void **,
		     void **);
static int line_line(struct lxline_type *, unsigned,
		     const struct screen_type *);
static int line_sail(struct lxline_type *, const struct screen_type *,
		     struct x1f4_linetext_type **, struct lxtext_type *,
		     const struct lxtype_type *, void **, void **);
static int line_text(struct lxline_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_line(struct lxline_type *, unsigned,
		     const struct screen_type *);
static int pick_miss(unsigned *, unsigned *, unsigned *, unsigned,
		     const struct screen_type *);
static int text_data(const struct screen_type *);

static void last_amix(v_case_args_____0);
static void line_amix(v_case_args_____0);
static void line_aset(u_case_args_____0);
static void line_bmix(v_case_args_____0);
static void line_bway(u_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_cmap(u_case_args_____0);
static void line_cset(u_case_args_____0);
static void line_cway(u_case_args_____0);
static void line_dfix(u_case_args_____0);
static void line_dmap(u_case_args_____0);
static void line_dmix(v_case_args_____0);
static void line_dset(u_case_args_____0);
static void line_dway(u_case_args_____0);
static void line_emix(v_case_args_____0);
static void line_esub(u_case_args_____0);
static void line_eway(u_case_args_____0);
static void line_fmix(v_case_args_____0);
static void line_fset(u_case_args_____0);
static void line_fsub(u_case_args_____0);
static void line_fway(u_case_args_____0);
static void line_gmap(u_case_args_____0);
static void line_gway(u_case_args_____0);
static void line_hfix(u_case_args_____0);
static void line_hmix(v_case_args_____0);
static void line_hset(u_case_args_____0);
static void line_imap(u_case_args_____0);
static void line_jmix(v_case_args_____0);
static void line_kfix(u_case_args_____0);
static void line_kway(v_case_args_____0);
static void line_lfar(v_case_args_____0);
static void line_lfix(u_case_args_____0);
static void line_lmap(u_case_args_____0);
static void line_rmix(v_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_lset(u_case_args_____0);
static void line_lway(u_case_args_____0);
static void line_nfix(v_case_args_____0);
static void line_nset(u_case_args_____0);
static void line_pfar(u_case_args_____0);
static void line_pmap(u_case_args_____0);
static void line_pmix(v_case_args_____0);
static void line_pset(u_case_args_____0);
static void line_pway(u_case_args_____0);
static void line_qmix(v_case_args_____0);
static void line_qset(u_case_args_____0);
static void line_rfix(u_case_args_____0);
static void line_rset(u_case_args_____0);
static void line_rsub(u_case_args_____0);
static void line_rway(u_case_args_____0);
static void line_smap(v_case_args_____0);
static void line_sset(u_case_args_____0);
static void line_sway(u_case_args_____0);
static void line_tmap(u_case_args_____0);
static void line_tmix(v_case_args_____0);
static void line_tset(u_case_args_____0);
static void line_tsub(u_case_args_____0);
#if __DISABLE_R_TRAVERSE__
#else
static void line_tway(u_case_args_____0);
#endif				/* __DISABLE_R_TRAVERSE__ */
static void line_vfix(v_case_args_____0);
static void line_vmix(v_case_args_____0);
static void line_uset(u_case_args_____0);
static void line_xmix(v_case_args_____0);
static void line_zmix(v_case_args_____0);

static const char fr_setf[] = "r_set", *const side_f[] = {
/* *INDENT-OFF* */
    fr_setf
/* *INDENT-ON* */
};
static const struct line_type auto_line[] = {
/* *INDENT-OFF* */
#define r_express_count			0
    {	{	"r_express",
		_libx1f4i0_lxline_e_centric,	0,
		NULL,				r_express_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						9		},
	line_esub,							},
#define r_express_reach			(0 + r_express_count)
#define r_extract_count			3
    {	{	"r_extract",
		_libx1f4i0_lxline_e_derived,	X1f4_E4_VOID,
		NULL,				r_extract_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_SLIP_LIST | X1f4_E4_TEXT_LINK,
						9		},
	line_eway,							},
#define r_extract_reach \
    (r_express_reach + (r_extract_count << 1))
#define r_fit_count			1
    {	{	"r_fit",
		_libx1f4i0_lxline_f_centric,	X1f4_E4_VOID,
		NULL,				r_fit_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						5		},
	line_fsub,							},
#define r_fit_reach			(r_extract_reach + r_fit_count)
#define r_get_count			3
    {	{	"r_get",
		_libx1f4i0_lxline_g_derived,	X1f4_E4_VOID,
		NULL,				r_get_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_SLIP_LIST | X1f4_E4_TEXT_LINK,
						5		},
	line_gway,							},
#define r_get_reach			(r_fit_reach + (r_get_count << 1))
#define r_high_count			1
    {	{	"r_high",
		_libx1f4i0_lxline_h_logique,	X1f4_E4_TEXT,
		NULL,				r_high_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_hfix,							},
#define r_high_reach			(r_get_reach + r_high_count)
#define r_low_count			1
    {	{	"r_low",
		_libx1f4i0_lxline_l_logique,	X1f4_E4_TEXT,
		NULL,				r_low_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_lfix,							},
#define r_low_reach			(r_high_reach + r_low_count)
#define r_render_count			0
    {	{	"r_render",
		_libx1f4i0_lxline_r_centric,	0,
		NULL,				r_render_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						8		},
	line_rsub,							},
#define r_render_reach			(r_low_reach + r_render_count)
#define r_tie_count			1
    {	{	"r_tie",
		_libx1f4i0_lxline_t_centric,	X1f4_E4_VOID,
		NULL,				r_tie_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_SIDE_LIST
		| X1f4_E4_TEXT_LINK,
						5		},
	line_tsub,							}
#define r_tie_reach			(r_render_reach + r_tie_count)
/* *INDENT-ON* */
#define auto_line_count			r_tie_reach
}, call_line[] = {
/* *INDENT-OFF* */
#define r_new_count			1
    {	{	"r_new",
		_libx1f4i0_lxline_n_forward,	X1f4_E4_VOID,
		NULL,				r_new_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_nset,							}
#define r_new_reach			(0 + (r_new_count << 1))
/* *INDENT-ON* */
#define call_line_count			r_new_reach
}, ever_line[] = {
/* *INDENT-OFF* */
#define r_set_count			2
    {	{	fr_setf,
		_libx1f4i0_lxline_s_forward,	0,
		NULL,				r_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_sset,							}
#define r_set_reach			(0 + (r_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			r_set_reach
}, fail_line[] = {
/* *INDENT-OFF* */
#define r_add_count			3
    {	{	"r_add",
		_libx1f4i0_lxline_a_forward,	X1f4_E4_VOID,
		NULL,				r_add_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_aset,							},
#define r_add_reach			(0 + r_add_count)
#define r_bind_count			3
    {	{	"r_bind",
		_libx1f4i0_lxline_b_derived,	X1f4_E4_VOID,
		NULL,				r_bind_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_bway,							},
#define r_bind_reach			(r_add_reach + r_bind_count)
#define r_case_count			3
    {	{	"r_case",
		_libx1f4i0_lxline_c_derived,	X1f4_E4_VOID,
		NULL,				r_case_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_cway,							},
#define r_case_reach			(r_bind_reach + r_case_count)
#define r_dock_count			3
    {	{	"r_dock",
		_libx1f4i0_lxline_d_derived,	X1f4_E4_VOID,
		NULL,				r_dock_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_dway,							},
#define r_dock_reach			(r_case_reach + r_dock_count)
#define r_fix_count			3
    {	{	"r_fix",
		_libx1f4i0_lxline_f_derived,	X1f4_E4_VOID,
		NULL,				r_fix_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_fway,							},
#define r_fix_reach			(r_dock_reach + r_fix_count)
#define r_head_count			1
    {	{	"r_head",
		_libx1f4i0_lxline_h_forward,	X1f4_E4_CASE,
		NULL,				r_head_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_hset,							},
#define r_head_reach			(r_fix_reach + r_head_count)
#define r_link_count			3
    {	{	"r_link",
		_libx1f4i0_lxline_l_derived,	X1f4_E4_VOID,
		NULL,				r_link_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_lway,							},
#define r_link_reach			(r_head_reach + r_link_count)
#define r_pick_count			2
    {	{	"r_pick",
		_libx1f4i0_lxline_p_derived,	X1f4_E4_CASE,
		NULL,				r_pick_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_pway,							},
#define r_pick_reach			(r_link_reach + r_pick_count)
#define r_put_count			3
    {	{	"r_put",
		_libx1f4i0_lxline_p_forward,	X1f4_E4_VOID,
		NULL,				r_put_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_pset,							},
#define r_put_reach			(r_pick_reach + r_put_count)
#define r_query_count			2
    {	{	"r_query",
		_libx1f4i0_lxline_q_forward,	X1f4_E4_CASE,
		NULL,				r_query_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_qset,							},
#define r_query_reach			(r_put_reach + r_query_count)
#define r_replace_count			3
    {	{	"r_replace",
		_libx1f4i0_lxline_r_derived,	X1f4_E4_VOID,
		NULL,				r_replace_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_rway,							},
#define r_replace_reach			(r_query_reach + r_replace_count)
#define r_tail_count			1
    {	{	"r_tail",
		_libx1f4i0_lxline_t_forward,	X1f4_E4_CASE,
		NULL,				r_tail_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_tset,							},
#define r_tail_reach			(r_replace_reach + r_tail_count)
#define rb_pick_count			1
    {	{	"rb_pick",
		_libx1f4i0_lxline_p_sequent,	X1f4_E4_CASE,
		NULL,				rb_pick_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pfar,							},
#define rb_pick_reach			(r_tail_reach + rb_pick_count)
#define rb_query_count			1
    {	{	"rb_query",
		_libx1f4i0_lxline_t_forward,	X1f4_E4_CASE,
		NULL,				rb_query_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_tset,							},
#define rb_query_reach			(rb_pick_reach + rb_query_count)
#define rf_pick_count			1
    {	{	"rf_pick",
		_libx1f4i0_lxline_p_pending,	X1f4_E4_CASE,
		NULL,				rf_pick_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pmap,							},
#define rf_pick_reach			(rb_query_reach + rf_pick_count)
#define rf_query_count			1
    {	{	"rf_query",
		_libx1f4i0_lxline_h_forward,	X1f4_E4_CASE,
		NULL,				rf_query_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_hset,							}
#define rf_query_reach			(rf_pick_reach + rf_query_count)
/* *INDENT-ON* */
#define fail_line_count		rf_query_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define r_class_count			1
    {	{	"r_class",
		_libx1f4i0_lxline_c_forward,	X1f4_E4_VOID,
		NULL,				r_class_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cset,							},
#define r_class_reach			(0 + r_class_count)
#define r_clear_count			1
    {	{	"r_clear",
		_libx1f4i0_lxline_c_pending,	X1f4_E4_VOID,
		NULL,				r_clear_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cmap,							},
#define r_clear_reach			(r_class_reach + r_clear_count)
#define r_copy_count			2
    {	{	"r_copy",
		_libx1f4i0_lxline_c_logique,	X1f4_E4_VOID,
		NULL,				r_copy_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_cfix,							},
#define r_copy_reach			(r_clear_reach + r_copy_count)
#define r_delete_count			2
    {	{	"r_delete",
		_libx1f4i0_lxline_d_logique,	X1f4_E4_VOID,
		NULL,				r_delete_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_dfix,							},
#define r_delete_reach			(r_copy_reach + r_delete_count)
#define r_down_count			2
    {	{	"r_down",
		_libx1f4i0_lxline_d_forward,	X1f4_E4_VOID,
		NULL,				r_down_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_dset,							},
#define r_down_reach			(r_delete_reach + r_down_count)
#define r_drop_count			2
    {	{	"r_drop",
		_libx1f4i0_lxline_d_pending,	X1f4_E4_VOID,
		NULL,				r_drop_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_dmap,							},
#define r_drop_reach			(r_down_reach + r_drop_count)
#define r_id_count			2
    {	{	"r_id",
		_libx1f4i0_lxline_i_pending,	X1f4_E4_MODE,
		NULL,				r_id_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_imap,							},
#define r_id_reach			(r_drop_reach + r_id_count)
#define r_key_count			2
    {	{	"r_key",
		_libx1f4i0_lxline_k_logique,	X1f4_E4_MODE,
		NULL,				r_key_count,
		X1f4_E4_KEEP_CALL,
						5		},
	line_kfix,							},
#define r_key_reach			(r_id_reach + r_key_count)
#define r_resign_count			2
    {	{	"r_resign",
		_libx1f4i0_lxline_r_logique,	X1f4_E4_VOID,
		NULL,				r_resign_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_rfix,							},
#define r_resign_reach			(r_key_reach + r_resign_count)
#define r_short_count			1
    {	{	"r_short",
		_libx1f4i0_lxline_s_derived,	X1f4_E4_VOID,
		NULL,				r_short_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_sway,							},
#define r_short_reach			(r_resign_reach + r_short_count)
#define r_size_count			1
    {	{	"r_size",
		_libx1f4i0_lxline_r_forward,	X1f4_E4_MODE,
		NULL,				r_size_count,
		0,				6		},
	line_rset,							},
#define r_size_reach			(r_short_reach + r_size_count)
#define r_swap_count			2
    {	{	"r_swap",
		_libx1f4i0_lxline_s_logique,	X1f4_E4_VOID,
		NULL,				r_swap_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_sfix,							},
#define r_swap_reach			(r_size_reach + r_swap_count)
#define r_type_count			2
    {	{	"r_type",
		_libx1f4i0_lxline_t_pending,	X1f4_E4_TEXT,
		NULL,				r_type_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_tmap,							},
#define r_type_reach			(r_swap_reach + r_type_count)
#define r_up_count			2
    {	{	"r_up",
		_libx1f4i0_lxline_u_forward,	X1f4_E4_VOID,
		NULL,				r_up_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_uset,							}
#define r_up_reach			(r_type_reach + r_up_count)
/* *INDENT-ON* */
#define slip_line_count			r_up_reach
}, text_line[] = {
/* *INDENT-OFF* */
#define r_first_count			2
    {	{	"r_first",
		_libx1f4i0_lxline_f_forward,	X1f4_E4_MODE,
		NULL,				r_first_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						7		},
	line_fset,							},
#define r_first_reach			(r_first_count << 1)
#define r_greater_count			3
    {	{	"r_greater",
		_libx1f4i0_lxline_g_pending,	X1f4_E4_MODE,
		NULL,				r_greater_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						9		},
	line_gmap,							},
#define r_greater_reach \
    (r_first_reach + (r_greater_count << 1))
#define r_last_count			2
    {	{	"r_last",
		_libx1f4i0_lxline_l_forward,	X1f4_E4_MODE,
		NULL,				r_last_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						6		},
	line_lset,							},
#define r_last_reach			(r_greater_reach + (r_last_count << 1))
#define r_less_count			3
    {	{	"r_less",
		_libx1f4i0_lxline_l_pending,	X1f4_E4_MODE,
		NULL,				r_less_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						6		},
	line_lmap,							}
#define r_less_reach			(r_last_reach + (r_less_count << 1))
/* *INDENT-ON* */
#define text_line_count		r_less_reach
};
static const struct link_type cast_line[] = {
/* *INDENT-OFF* */
#define r_q__class			4
#define r_q__count			2
    {	{	"r_q_",
		NULL,				0,
		NULL,				r_q__count,
		X1f4_E4_TEXT_LINK,		r_q__class	},
	line_qmix,							},
#define r_q__reach			(0 + r_q__count)
#define r_q__trans			(0 + r_q__class)
#define rb_q__class			5
#define rb_q__count			1
    {	{	"rb_q_",
		NULL,				0,
		NULL,				rb_q__count,
		X1f4_E4_TEXT_LINK,		rb_q__class	},
	line_tmix,							},
#define rb_q__reach			(r_q__reach + rb_q__count)
#define rb_q__trans			(r_q__trans + rb_q__class)
#define rf_q__class			5
#define rf_q__count			1
    {	{	"rf_q_",
		NULL,				0,
		NULL,				rf_q__count,
		X1f4_E4_TEXT_LINK,		rf_q__class	},
	line_hmix,							}
#define rf_q__reach			(rb_q__reach + rf_q__count)
#define rf_q__trans			(rb_q__trans + rf_q__class)
/* *INDENT-ON* */
#define cast_line_class			rf_q__trans
#define cast_line_count			rf_q__reach
#define cast_line_shift \
    sizeof(cast_line) / sizeof(struct link_type)
}, copy_line[] = {
/* *INDENT-OFF* */
#define r_a__class			4
#define r_a__count			3
    {	{	"r_a_",
		NULL,				X1f4_E4_VOID,
		NULL,				r_a__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						r_a__class	},
	line_amix,							},
#define r_a__reach			(0 + r_a__count)
#define r_a__trans			(0 + r_a__class)
#define r_f__class			4
#define r_f__count			3
    {	{	"r_f_",
		NULL,				X1f4_E4_VOID,
		NULL,				r_f__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						r_f__class	},
	line_fmix,							},
#define r_f__reach			(r_a__reach + r_f__count)
#define r_f__trans			(r_a__trans + r_f__class)
#define r_p__class			4
#define r_p__count			3
    {	{	"r_p_",
		NULL,				X1f4_E4_VOID,
		NULL,				r_p__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						r_p__class	},
	line_pmix,							},
#define r_p__reach			(r_f__reach + r_p__count)
#define r_p__trans			(r_f__trans + r_p__class)
#define r_r__class			4
#define r_r__count			3
    {	{	"r_r_",
		NULL,				X1f4_E4_VOID,
		NULL,				r_r__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						r_r__class	},
	line_rmix,							}
#define r_r__reach			(r_p__reach + r_r__count)
#define r_r__trans			(r_p__trans + r_r__class)
/* *INDENT-ON* */
#define copy_line_class			r_r__trans
#define copy_line_count			r_r__reach
#define copy_line_shift \
    sizeof(copy_line) / sizeof(struct link_type)
}, fast_line[] = {
/* *INDENT-OFF* */
#define r_e__class			4
#define r_e__count			3
    {	{	"r_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				r_e__count,
		0,				r_e__class	},
	line_emix,							},
#define r_e__reach			(0 + r_e__count)
#define r_e__trans			(0 + r_e__class)
#define r_s__class			4
#define r_s__count			2
    {	{	"r_s_",
		_libx1f4i0_lxline_s_pending,	X1f4_E4_MODE,
		NULL,				r_s__count,
		X1f4_E4_TEXT_LINK,		r_s__class	},
	line_smap,							},
#define r_s__reach			(r_e__reach + r_s__count)
#define r_s__trans			(r_e__trans + r_s__class)
#define rb_e__class			5
#define rb_e__count			2
    {	{	"rb_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				rb_e__count,
		0,				rb_e__class	},
	line_vmix,							},
#define rb_e__reach			(r_s__reach + rb_e__count)
#define rb_e__trans			(r_s__trans + rb_e__class)
#define rf_e__class			5
#define rf_e__count			2
    {	{	"rf_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				rf_e__count,
		0,				rf_e__class	},
	line_dmix,							}
#define rf_e__reach			(rb_e__reach + rf_e__count)
#define rf_e__trans			(rb_e__trans + rf_e__class)
/* *INDENT-ON* */
#define fast_line_class			rf_e__trans
#define fast_line_count			rf_e__reach
#define fast_line_shift \
    sizeof(fast_line) / sizeof(struct link_type)
}, land_line[] = {
/* *INDENT-OFF* */
#define r_j__count			3
    {	{	"r_j_",
		NULL,				X1f4_E4_MODE,
		NULL,				r_j__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,		4		},
	line_jmix,							}
#define r_j__reach			(0 + (r_j__count << 1))
/* *INDENT-ON* */
#define land_line_class			(land_line_shift * 4)
#define land_line_count			r_j__reach
#define land_line_shift \
    sizeof(land_line) / sizeof(struct link_type)
}, long_line[] = {
/* *INDENT-OFF* */
#define r_b__count			3
    {	{	"r_b_",
		_libx1f4i0_lxline_b_sequent,	X1f4_E4_VOID,
		NULL,				r_b__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_lfar,							},
#define r_b__reach			(0 + r_b__count)
#define r_c__count			3
    {	{	"r_c_",
		_libx1f4i0_lxline_c_sequent,	X1f4_E4_VOID,
		NULL,				r_c__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_lfar,							},
#define r_c__reach			(r_b__reach + r_c__count)
#define r_d__count			3
    {	{	"r_d_",
		_libx1f4i0_lxline_d_sequent,	X1f4_E4_VOID,
		NULL,				r_d__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_lfar,							},
#define r_d__reach			(r_c__reach + r_d__count)
#define r_l__count			3
    {	{	"r_l_",
		_libx1f4i0_lxline_l_sequent,	X1f4_E4_VOID,
		NULL,				r_l__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_lfar,							}
#define r_l__reach			(r_d__reach + r_l__count)
/* *INDENT-ON* */
#define long_line_class			(long_line_shift * 4)
#define long_line_count			r_l__reach
#define long_line_shift \
    sizeof(long_line) / sizeof(struct link_type)
}, past_line[] = {
/* *INDENT-OFF* */
#define r_x__class			4
#define r_x__count			2
    {	{	"r_x_",
		NULL,				0,
		NULL,				r_x__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						r_x__class	},
	line_xmix,							},
#define r_x__reach			(0 + r_x__count)
#define r_x__trans			(0 + r_x__class)
#define rb_x__class			5
#define rb_x__count			1
    {	{	"rb_x_",
		NULL,				X1f4_E4_VOID,
		NULL,				rb_x__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						rb_x__class	},
	line_zmix,							},
#define rb_x__reach			(r_x__reach + rb_x__count)
#define rb_x__trans			(r_x__trans + rb_x__class)
#define rf_x__class			5
#define rf_x__count			1
    {	{	"rf_x_",
		NULL,				X1f4_E4_VOID,
		NULL,				rf_x__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						rf_x__class	},
	line_bmix,							}
#define rf_x__reach			(rb_x__reach + rf_x__count)
#define rf_x__trans			(rb_x__trans + rf_x__class)
/* *INDENT-ON* */
#define past_line_class			rf_x__trans
#define past_line_count			rf_x__reach
#define past_line_shift \
    sizeof(past_line) / sizeof(struct link_type)
}, seek_line[] = {
/* *INDENT-OFF* */
#define r_k__count			3
    {	{	"r_k_",
		_libx1f4i0_lxline_k_derived,	X1f4_E4_MODE,
		NULL,				r_k__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,		4		},
	line_kway,							}
#define r_k__reach			(0 + (r_k__count << 1))
/* *INDENT-ON* */
#define seek_line_class			(seek_line_shift * 4)
#define seek_line_count			r_k__reach
#define seek_line_shift \
    sizeof(seek_line) / sizeof(struct link_type)
}, skew_line[] = {
/* *INDENT-OFF* */
#define rn_a__count			3
    {	{	"rn_a_",
		NULL,				0,
		NULL,				rn_a__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	last_amix,							}
#define rn_a__reach			(0 + rn_a__count)
/* *INDENT-ON* */
#define skew_line_class			(skew_line_shift * 5)
#define skew_line_count			rn_a__reach
#define skew_line_shift \
    sizeof(skew_line) / sizeof(struct link_type)
}, spin_line[] = {
/* *INDENT-OFF* */
#define r_n__count			2
    {	{	"r_n_",
		_libx1f4i0_lxline_n_logique,	0,
		NULL,				r_n__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_nfix,							},
#define r_n__reach			(0 + r_n__count)
#define r_v__count			2
    {	{	"r_v_",
		_libx1f4i0_lxline_v_logique,	0,
		NULL,				r_v__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						4		},
	line_vfix,							}
#define r_v__reach			(r_n__reach + r_v__count)
/* *INDENT-ON* */
#define spin_line_class			(spin_line_shift * 4)
#define spin_line_count			r_v__reach
#define spin_line_shift \
    sizeof(spin_line) / sizeof(struct link_type)
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_line(struct lxline_type *lxline_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & AUTOLINK_LINK) {
	lxline_data->link_v.data = screen_data->link_v.data;
	lxline_data->link_v.free = screen_data->link_v.free;
	lxline_data->link_v.link = screen_data->link_v.link;
	lxline_data->link_v.mode = screen_data->link_v.mode;
	lxline_data->link_v.pick = screen_data->link_v.pick;
	lxline_data->link_v.slip = screen_data->link_v.slip;
    } else {
	bits &= ~EVERLINK_SLIP;

	lxline_data->link_v.data = NULL;
	lxline_data->link_v.free = NULL;
	lxline_data->link_v.link = NULL;
	lxline_data->link_v.mode = NULL;
	lxline_data->link_v.pick = NULL;
	lxline_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxline_data->link_w.data = screen_data->link_w.data;
	lxline_data->link_w.free = screen_data->link_w.free;
	lxline_data->link_w.link = screen_data->link_w.link;
	lxline_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxline_data->link_w.data = NULL;
	lxline_data->link_w.free = _x1f4_e4_free_data;
	lxline_data->link_w.link = _x1f4_e4_link_data;
	lxline_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & CASTTYPE_LINK) {
	lxline_data->link_v.data = screen_data->link_v.data;
	lxline_data->link_v.free = screen_data->link_v.free;
	lxline_data->link_v.link = screen_data->link_v.link;
	lxline_data->link_v.mode = screen_data->link_v.mode;
	lxline_data->link_v.pick = screen_data->link_v.pick;
	lxline_data->link_v.slip = screen_data->link_v.slip;
    } else {
	lxline_data->link_v.data = NULL;
	lxline_data->link_v.free = NULL;
	lxline_data->link_v.link = NULL;
	lxline_data->link_v.mode = NULL;
	lxline_data->link_v.pick = NULL;
	lxline_data->link_v.slip = NULL;
    }

    if (bits & EELOOKUP_LINK) {
	lxline_data->trap_e.eelookup_data = screen_data->trap_e.eelookup_data;
    } else {
	lxline_data->trap_e.eelookup_data = &_x1f4_type_lookup;
    }

    if (bits & MISSBAIL_LINK) {
	lxline_data->link_r.call = screen_data->link_r.call;
	lxline_data->link_r.fine = screen_data->link_r.fine;
	lxline_data->link_r.miss = screen_data->link_r.miss;
	lxline_data->link_r.text = screen_data->link_r.text;
    } else {
	lxline_data->link_r.call = NULL;
	lxline_data->link_r.fine = NULL;
	lxline_data->link_r.miss = NULL;
    }

    if (bits & RESOURCE_LINK) {
	lxline_data->link_m.data = screen_data->link_m.data;
	lxline_data->link_m.free = screen_data->link_m.free;
	lxline_data->link_m.link = screen_data->link_m.link;
	lxline_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxline_data->link_m.data = NULL;
	lxline_data->link_m.free = _x1f4_e4_free_data;
	lxline_data->link_m.link = _x1f4_e4_link_data;
	lxline_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxline_data->link_e.data = screen_data->link_e.data;
	lxline_data->link_e.line = screen_data->link_e.line;
	lxline_data->link_e.post = screen_data->link_e.post;
	lxline_data->link_e.push = screen_data->link_e.push;
    } else {
	lxline_data->link_e.data = NULL;
	lxline_data->link_e.line = NULL;
	lxline_data->link_e.post = NULL;
	lxline_data->link_e.push = NULL;
    }

    if (bits & TRANSFER_LINK) {
	lxline_data->link_o.fine = screen_data->link_o.fine;
    } else {
	lxline_data->link_o.fine = NULL;
    }

    status = link_line(lxline_data, bits, screen_data);

    return status;
}


static int
line_data(struct lxline_type *lxline_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void *text,
	  void **args, void **dana)
{
    struct lxtext_type *lxtext_data;
    const struct lxtype_type *lxtype_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    lxtype_data = screen_data->link_t.data;

    linetext_data = data;
    lxtext_data = text;

    lxtype_data--;

    _x1f4_type_effect(&lxtext_data->lxtype, X1f4_E4_CALL);
    lxtext_data->text = lxline_data;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	int code;
	unsigned flags;

	lxtext_data++;

	lxtype_data++;

	line_sail
	    (lxline_data, screen_data, &linetext_data, lxtext_data,
	     lxtype_data, args, dana);

	flags = lxtype_data->flags;

	if (flags & X1f4_LX_TYPE_EXCEPT) {
	    continue;
	}

	if (1) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, fast_line_shift, fast_line);
	}
	if (bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, cast_line_shift, cast_line);
	}

	code = lxtype_data->code;

	if (code == X1f4_E4_BILL || code == X1f4_E4_MODE
	    || code == X1f4_E4_REAL) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, land_line_shift, land_line);
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, skew_line_shift, skew_line);
	}

	if (code == X1f4_E4_TEXT) {
	    _libx1f4i0_lxcall_side_line
		(lxtext_data, bits, screen_data, linetext_data, args,
		 sizeof(text_line) / sizeof(struct line_type), text_line);
	    linetext_data += sizeof(text_line) / sizeof(struct line_type);
	}

	if (X1f4_E4_LAST < code && lxtype_data->lead) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, land_line_shift, land_line);
	}

	if (bits & AUTOLINK_LINK
	    || (!lxtype_data->lead && code != X1f4_E4_TEXT)) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, past_line_shift, past_line);
	}

	if (flags & LINK_ACCESS) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, long_line_shift, long_line);
	}
	if (0) {
	} else {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, copy_line_shift, copy_line);
	}
	if (flags & POST_ACCESS && bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, spin_line_shift, spin_line);
	}
	if (flags & POST_ACCESS && X1f4_E4_LAST < code && lxtype_data->lead) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, seek_line_shift, seek_line);
	}
    }

    return 0;
}


static int
line_line(struct lxline_type *lxline_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxline_data->link_t.datatype[0].context = lxline_data;

    lxline_data->link_t.datatype[0].flat = _libx1f4i0_lxline_flat_line;
    lxline_data->link_t.datatype[0].lead = _libx1f4i0_lxline_lead_line;
    lxline_data->link_t.datatype[0].line = _libx1f4i0_lxline_line_line;
    lxline_data->link_t.datatype[0].link = _libx1f4i0_lxline_link_line;
    lxline_data->link_t.datatype[0].name = "record";
    lxline_data->link_t.datatype[0].shut = _libx1f4i0_lxline_flat_line;
    lxline_data->link_t.datatype[0].slip = _libx1f4i0_lxline_slip_line;
    lxline_data->link_t.datatype[0].size = 6;
    lxline_data->link_t.datatype[0].type = screen_data->link_l.type;

    lxline_data->link_t.datatype[1].context = NULL;

    lxline_data->link_t.datatype[1].flat = NULL;
    lxline_data->link_t.datatype[1].lead = NULL;
    lxline_data->link_t.datatype[1].line = NULL;
    lxline_data->link_t.datatype[1].link = NULL;
    lxline_data->link_t.datatype[1].name = NULL;
    lxline_data->link_t.datatype[1].shut = NULL;
    lxline_data->link_t.datatype[1].slip = NULL;
    lxline_data->link_t.datatype[1].size = 0;
    lxline_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_sail(struct lxline_type *lxline_data,
	  const struct screen_type *screen_data,
	  struct x1f4_linetext_type **linetext,
	  struct lxtext_type *lxtext_data,
	  const struct lxtype_type *lxtype_data, void **subtext, void **dana)
{
    int code;
    struct x1f4_linetext_type *linetext_data;

    code = lxtype_data->code;

    linetext_data = *linetext;

    lxtext_data->lxtype = *lxtype_data;
    lxtext_data->text = lxline_data;

    if (code == screen_data->link_l.type) {
	lxline_data->link_n.node = &lxtext_data->lxtype;
    } else {
	if (code == X1f4_E4_TEXT) {
	    lxtext_data->lxtype.context = lxline_data;

	    lxtext_data->lxtype.copy = _libx1f4i0_lxline_copy_text;
	    lxtext_data->lxtype.free = _libx1f4i0_lxline_free_text;
	    lxtext_data->lxtype.lead = _libx1f4i0_lxline_lead_text;
	    lxtext_data->lxtype.move = NULL;
	    lxtext_data->lxtype.push = _libx1f4i0_lxline_push_text;
	    lxtext_data->lxtype.slip = _libx1f4i0_lxline_slip_text;
	}
    }

    *linetext = linetext_data;

    return 0;
}


static int
line_text(struct lxline_type *lxline_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxline_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & AUTOLINK_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxline_data, bits, screen_data, linetext_data, args,
	     sizeof(auto_line) / sizeof(struct line_type), auto_line);
	linetext_data += sizeof(auto_line) / sizeof(struct line_type);
    }
    if (bits & CASTTYPE_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxline_data, bits, screen_data, linetext_data, args,
	     sizeof(fail_line) / sizeof(struct line_type), fail_line);
	linetext_data += sizeof(fail_line) / sizeof(struct line_type);
    }
    if (bits & RESETNEW_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxline_data, bits, screen_data, linetext_data, args,
	     sizeof(call_line) / sizeof(struct line_type), call_line);
	linetext_data += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxline_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_line(struct lxline_type *lxline_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_class, args_count, line_class, line_count, main_class,
	main_count, miss;
    void *data;

    args_count = 0;
    line_count = 1;
    main_count = 0;

    pick_miss(&args_class, &line_class, &main_class, bits, screen_data);

    miss = screen_data->link_t.miss;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & AUTOLINK_LINK) {
	args_count += auto_line_count;
	line_count += sizeof(auto_line) / sizeof(struct line_type);
    }
    if (bits & CASTTYPE_LINK) {
	args_count += fail_line_count;
	line_count += sizeof(fail_line) / sizeof(struct line_type);
    }
    if (bits & RESETNEW_SLIP) {
	args_count += call_line_count;
	line_count += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (text_data(screen_data)) {
	args_class += text_line_count;
	line_class += sizeof(text_line) / sizeof(struct line_type);
    }

    status = lxline_data->link_w.link
	(lxline_data->link_w.data, &data,
	 sizeof(struct lxtext_type) * (1 + miss) + fm_size(away)
	 + (args_class + args_count) * sizeof(int)
	 + (line_class + line_count) * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *)
	 + main_class + main_count);
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side, *tile, *text;

	tile = (struct x1f4_linetext_type *) data + line_class;
	dana = (struct x1f4_linetext_type *) tile + line_count;
	text = (struct lxmiss_type *) dana + 1;
	side = (struct lxtext_type *) text + 1 + miss;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;
	dana = (int *) args + args_class + args_count;

	lxline_data->link_f.data = data;
	lxline_data->link_f.side = side;
	lxline_data->link_f.text = text;

	((struct lxmiss_type *) text - 1)->data.miss = miss;

	line_data(lxline_data, bits, screen_data, data, text, &args, &dana);
	line_text(lxline_data, bits, screen_data, tile, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_line(lxline_data, bits, screen_data);

#if __DISABLE_R_TRAVERSE__
#else
	lxline_data->link_k.node = NULL;
#endif				/* __DISABLE_R_TRAVERSE__ */

	if (status) {
	    lxline_data->link_w.free(lxline_data->link_w.data, data);
	} else {
	}
    }

    return status;
}


static int
pick_miss(unsigned *args, unsigned *line, unsigned *pick, unsigned bits,
	  const struct screen_type *screen_data)
{
    const struct lxtype_type *lxtype_data;
    unsigned args_count = 0, line_count = 0, i, main_count = 0;

    lxtype_data = screen_data->link_t.data;
    lxtype_data--;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	int code;
	unsigned deck, flags;

	lxtype_data++;

	flags = lxtype_data->flags;

	if (flags & X1f4_LX_TYPE_EXCEPT) {
	    continue;
	}

	deck = lxtype_data->size + 1;

	if (1) {
	    args_count += fast_line_count;
	    line_count += fast_line_shift;
	    main_count += deck * fast_line_shift + fast_line_class;
	}
	if (bits & AUTOLINK_LINK) {
	    args_count += cast_line_count;
	    line_count += cast_line_shift;
	    main_count += deck * cast_line_shift + cast_line_class;
	}

	code = lxtype_data->code;

	/*
	 * _r_g__ and alike retrievers
	 */
	if (code == X1f4_E4_BILL || code == X1f4_E4_MODE
	    || code == X1f4_E4_REAL) {
	    args_count += land_line_count;
	    line_count += land_line_shift;
	    main_count += deck * land_line_shift + land_line_class;
	    args_count += skew_line_count;
	    line_count += skew_line_shift;
	    main_count += deck * skew_line_shift + skew_line_class;
	}

	/*
	 * _r_j__ and alike retrievers
	 */
	if (X1f4_E4_LAST < code && lxtype_data->lead) {
	    args_count += land_line_count;
	    line_count += land_line_shift;
	    main_count += deck * land_line_shift + land_line_class;
	}

	if (bits & AUTOLINK_LINK
	    || (!lxtype_data->lead && code != X1f4_E4_TEXT)) {
	    args_count += past_line_count;
	    line_count += past_line_shift;
	    main_count += deck * past_line_shift + past_line_class;
	}

	if (flags & FLAT_REFLEX) {
	} else {
	    args_count += l_d_type_post;
	    args_count += l_e_type_post;
	    args_count += l_v_type_post;
	}
	if (flags & LINK_ACCESS) {
	    args_count += long_line_count;
	    line_count += long_line_shift;
	    main_count += deck * long_line_shift + long_line_class;
	}
	if (0) {
	} else {
	    args_count += copy_line_count;
	    line_count += copy_line_shift;
	    main_count += deck * copy_line_shift + copy_line_class;
	}
	if (flags & POST_ACCESS && bits & AUTOLINK_LINK) {
	    args_count += spin_line_count;
	    line_count += spin_line_shift;
	    main_count += deck * spin_line_shift + spin_line_class;
	}
	if (flags & POST_ACCESS && X1f4_E4_LAST < code && lxtype_data->lead) {
	    args_count += seek_line_count;
	    line_count += seek_line_shift;
	    main_count += deck * seek_line_shift + seek_line_class;
	}
    }

    *args = args_count;
    *line = line_count;
    *pick = main_count;

    return 0;
}


static int
text_data(const struct screen_type *screen_data)
{
    const struct lxtype_type *lxtype_data;
    unsigned i;

    lxtype_data = screen_data->link_t.data;
    i = screen_data->link_t.miss;
    while (i) {
	if (lxtype_data->code == X1f4_E4_TEXT) {
	    break;
	} else {
	    i--;
	    lxtype_data++;
	}
    }

    return i;
}


static void
last_amix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = type;

    *args = line;

    if (type == X1f4_E4_REAL) {
	linetext_data->function.function = _libx1f4i0_lxline_a_break_r;
    } else {
	if (type == X1f4_E4_MODE) {
	    linetext_data->function.function = _libx1f4i0_lxline_a_break_m;
	} else {
	    if (1) {
		linetext_data->function.function = _libx1f4i0_lxline_a_break_b;
	    } else {
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_amix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxline_a_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_a_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_a_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_a_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_a_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_a_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_aset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_bmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    linetext_data->function.type = nodetype_data->code;

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxline_b_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_b_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_b_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_b_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_b_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_b_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_bway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_dfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_dmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_dmix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxline_d_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_d_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_d_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_d_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_d_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_d_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_dset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_dway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_emix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxline_e_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_e_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_e_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_e_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_e_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_e_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_esub(u_case_args_____1)
{
    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_eway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = X1f4_E4_SLIP;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;
    *line++ = 0;

    *args = line;
}


static void
line_fmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxline_f_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_f_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_f_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_f_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_f_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_f_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_fset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_fsub(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_fway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_gmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_gway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = X1f4_E4_SLIP;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;
    *line++ = 0;

    *args = line;
}


static void
line_hfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_hmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxline_h_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_h_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_h_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_h_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_h_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_h_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_hset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_imap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_jmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;
    *line++ = 0;

    *args = line;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxline_j_class_v;
    } else {
	if (0) {
	} else {
	    if (0) {
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_j_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_j_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_j_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_kfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_kway(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = nodetype_data->code;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;
    *line++ = 0;

    *args = line;
}


static void
line_lfar(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_lfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_lmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_lset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = 0;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_lway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_nfix(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;

    linetext_data->function.type = nodetype_data->code;
}


static void
line_nset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_pfar(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_pmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxline_p_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_p_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_p_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_p_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_p_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_p_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_pset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_pway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_qmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxline_q_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_q_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_q_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_q_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_q_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_q_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_qset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_rfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_rmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(nodetype_data)) {
	linetext_data->function.function = _libx1f4i0_lxline_r_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_r_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_r_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_r_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_r_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_r_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_rset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_rsub(u_case_args_____1)
{
    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_rway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_CASE;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_smap(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_sway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_tmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_tmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxline_t_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_t_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_t_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_t_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_t_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_t_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_tset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_tsub(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


#if __DISABLE_R_TRAVERSE__
#else
static void
line_tway(u_case_args_____1)
{
    int back[2], *line;
    struct x1f4_linetext_type linetext;

    line = *args;

    linetext_data->function.args = line;

    linetext.function.args = back;
    linetext.function.count = 2;
    linetext.function.flags = 0;
    linetext.function.type = X1f4_E4_VOID;

    back[0] = X1f4_E4_CASE;
    back[1] = X1f4_E4_CASE;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_CASE;
    /*
     * TODO/BUGS
     *
     * .errors are not checked, look to fix
     * .check if link_o.fine is available
     */
    x1f4_type_e4fine(screen(screen)->link_o.fine, line, &linetext);
    line++;

    *args = line;
}
#endif				/* __DISABLE_R_TRAVERSE__ */


static void
line_vfix(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;

    linetext_data->function.type = nodetype_data->code;
}


static void
line_vmix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxline_v_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_v_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_v_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_v_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_v_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_v_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_uset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_xmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;

    linetext_data->function.type = type;

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxline_x_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_x_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_x_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_x_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_x_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_x_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_zmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    linetext_data->function.type = nodetype_data->code;

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxline_z_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxline_z_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxline_z_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxline_z_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxline_z_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxline_z_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


int
x1f4_init_lxline(void **lxline, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *line, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &line, sizeof(struct lxline_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_line(line, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, line);
	    } else {
		_x1f4_e4_free_data(text, line);
	    }
	} else {
	    *lxline = line;
	}
    }

    return status;
}
