/*
 * lxlead-types.h
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxlead_types_H__
#define __LIBx1f4_lxlead_types_H__

#include <config.h>

#include <ln.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define here_NULL			((void *) 0)

#define here_offsetof(type, ceil) \
    ((integral_q) (&((type *) here_NULL)->ceil))

#define lock_excase(dxlist_text) \
    ((struct x1f4_nodelink_type *) &lock_cxlist((dxlist_text))->link)

#define lock_exlist(dxlist_text) \
    ((struct x1f4_nodeline_type *) &lock_cxlist((dxlist_text))->line)

#define lock_cxlist(dxlist_text) \
    ((struct x1f4_leadnode_type *)					      \
     ((char *) (dxlist_text) - sizeof(struct x1f4_leadnode_type)))

#define near_exlist(excase_text) \
    ((struct x1f4_nodeline_type *) &near_fxlist((excase_text))->line)

#define near_fxlist(excase_text) \
    ((struct x1f4_leadnode_type *)					      \
     ((char *) (excase_text) - here_offsetof(struct x1f4_leadnode_type, link)))

#endif				/* __LIBx1f4_lxlead_types_H__ */
