/*
 * lxlead-e.s.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <cl.h>
#include <e4.h>
#include <exerrors.h>
#include <lxfset.h>
#include <nt.h>
#include <trans.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

int
x1f4_pull_lxlead(void *bqpp, void *list, const void *data,
		 int *class, struct trans_type *trans_data,
		 struct x1f4_caselink_type **caselink,
		 struct x1f4_nodetype_type *nodetype_data,
		 const struct x1f4_nodelink_type *nodelink_data)
{
    int delete = 1, status;

    do {
	int (*copy) (void *, void *, void **, const void *,
		     const struct x1f4_nodelink_type *);

	if (nodetype_data->flags & X1f4_LX_LINK_ACCESS) {
	    void *record;

	    if (x1f4_find_lxfset(bqpp, (void *) data, &record)) {
		status = nodetype_data->node
		    (nodetype_data->context, (void *) list,
		     ((void **) record)[1], nodelink_data);
		if (1) {
		    break;
		}
	    }
	}

	if (nodetype_data->flags & X1f4_LX_PULL_ACCESS) {
	    status = nodetype_data->post
		(nodetype_data->context, (void *) list, nodelink_data);
	    if (status) {
	    } else {
		void *pull;

		if (nodetype_data->flags & X1f4_LX_LINK_ACCESS) {
		    void *record;

		    status = x1f4_post_lxfset(bqpp, (void *) data, &record);
		    if (status) {
			status = X1f4_EX_CRITICAL;

			nodetype_data->free
			    (nodetype_data->context, I_USER(list),
			     NULL, nodelink_data);
			if (1) {
			    break;
			}
		    } else {
			void **node;

			node = record;
			node[0] = I_USER(data);
			node[1] = I_USER(list);
		    }
		}

		status = trans_data->link
		    (trans_data->data, &pull,
		     sizeof(struct x1f4_caselink_type));
		if (status) {
		    status = X1f4_EX_CRITICAL;

		    nodetype_data->free
			(nodetype_data->context, I_USER(list), NULL,
			 nodelink_data);
		} else {
		    struct x1f4_caselink_type *caselink_data;

		    caselink_data = pull;

		    caselink_data->caselink_data = *caselink;

		    caselink_data->nodetype_data = nodetype_data;

		    caselink_data->data = I_USER(list);
		    caselink_data->text = I_USER(data);

		    *caselink = caselink_data;
		}
	    }

	    break;
	}

	copy = nodetype_data->copy;
	if (copy) {
	    status = copy
		(nodetype_data->context, bqpp, (void *) list,
		 I_USER(data), nodelink_data);
	    if (status) {
	    } else {
		if ((nodetype_data->flags
		     & (X1f4_LX_LINK_ACCESS | X1f4_LX_AUTO_RECORD))
		    ^ X1f4_LX_LINK_ACCESS) {
		} else {
		    void *record;

		    status = x1f4_post_lxfset(bqpp, (void *) data, &record);
		    if (status) {
			status = X1f4_EX_CRITICAL;

			nodetype_data->free
			    (nodetype_data->context, I_USER(list),
			     NULL, nodelink_data);
		    } else {
			void **node;

			node = record;
			node[0] = I_USER(data);
			node[1] = I_USER(list);
		    }
		}
	    }

	    break;
	}

	delete = 0;

	status = 0;
    } while (0);

    *class = status;

    return delete;
}
